/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.apiimpl;

import com.install4j.api.ApplicationRegistry;
import com.install4j.api.Util;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.InstallationProperties;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.registry.InstallRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ApplicationRegistryImpl {
    public static boolean checkApplicationId(File file) {
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        String string = InstallerUtil.getOldApplicationId(file);
        String string2 = installerConfig.getTargetApplicationId();
        if (!installerConfig.isAddOnInstaller()) {
            return string == null || string.trim().length() == 0 || string.equals(string2);
        }
        if (string == null) {
            return false;
        }
        return string.equals(string2);
    }

    public static boolean isUpdateDirectory(File file) {
        if (file == null || !file.exists() || !file.isDirectory()) {
            return false;
        }
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        String string = InstallerUtil.getOldApplicationId(file);
        String string2 = installerConfig.getApplicationId();
        return string != null && string.equals(string2);
    }

    public static ApplicationRegistry.ApplicationInfo[] getApplicationInfoById(String string) {
        ArrayList<ApplicationRegistry.ApplicationInfo> arrayList = new ArrayList<ApplicationRegistry.ApplicationInfo>();
        String[] stringArray = InstallRegistry.getAllInstallationDirs(string);
        for (int i = 0; i < stringArray.length; ++i) {
            File file;
            String string2;
            String string3 = stringArray[i];
            ApplicationRegistry.ApplicationInfo applicationInfo = ApplicationRegistryImpl.getApplicationInfoByDir(new File(string3));
            if (applicationInfo != null && string.equals(applicationInfo.getId())) {
                arrayList.add(applicationInfo);
            }
            if (!Util.isMacOS() || (string2 = InstallRegistry.getSingleBundleName(string, string3)) == null || (applicationInfo = ApplicationRegistryImpl.getApplicationInfoByDir(file = new File(string3, string2 + "/" + "Contents/Resources/app"))) == null || !string.equals(applicationInfo.getId())) continue;
            arrayList.add(applicationInfo);
        }
        return arrayList.toArray(new ApplicationRegistry.ApplicationInfo[arrayList.size()]);
    }

    public static ApplicationRegistry.ApplicationInfo getApplicationInfoByDir(File file) {
        InstallerConfig installerConfig = InstallerUtil.getOldApplicationConfig(file);
        if (installerConfig == null) {
            return null;
        }
        ApplicationInfoImpl applicationInfoImpl = new ApplicationInfoImpl();
        applicationInfoImpl.id = installerConfig.getApplicationId();
        applicationInfoImpl.name = installerConfig.getApplicationName();
        applicationInfoImpl.version = installerConfig.getApplicationVersion();
        applicationInfoImpl.mediaSetId = installerConfig.getMediaSetId();
        applicationInfoImpl.installationDirectory = file;
        return applicationInfoImpl;
    }

    public static ApplicationRegistry.ApplicationInfo[] getAddOnApplicationInfoByDir(File file) {
        List list = InstallerUtil.getAddOnApplicationConfigs(file);
        if (list == null) {
            return null;
        }
        ApplicationRegistry.ApplicationInfo[] applicationInfoArray = new ApplicationRegistry.ApplicationInfo[list.size()];
        InstallationProperties installationProperties = new InstallationProperties(new File(file, ".install4j"));
        for (int i = 0; i < list.size(); ++i) {
            InstallerConfig installerConfig = (InstallerConfig)list.get(i);
            ApplicationInfoImpl applicationInfoImpl = new ApplicationInfoImpl();
            applicationInfoImpl.id = installerConfig.getApplicationId();
            applicationInfoImpl.name = installerConfig.getApplicationName();
            applicationInfoImpl.version = installerConfig.getApplicationVersion();
            applicationInfoImpl.mediaSetId = installerConfig.getMediaSetId();
            applicationInfoImpl.installationDirectory = file;
            applicationInfoArray[i] = applicationInfoImpl;
        }
        return applicationInfoArray;
    }

    private static class ApplicationInfoImpl
    implements ApplicationRegistry.ApplicationInfo {
        private File installationDirectory;
        private String id;
        private String name;
        private String version;
        private String mediaSetId;

        private ApplicationInfoImpl() {
        }

        public String getMediaSetId() {
            return this.mediaSetId;
        }

        public File getInstallationDirectory() {
            return this.installationDirectory;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String toString() {
            return "ApplicationInfo: " + this.getName() + " " + this.getVersion() + " (id: " + this.getId() + "), dir: " + this.getInstallationDirectory();
        }
    }
}

