/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens;

import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.screens.SystemScreen;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public abstract class ChecklistScreen
extends SystemScreen {
    private JScrollPane scpChecklist;
    protected JPanel checklistPanel;
    protected List singleCheckPanels = new ArrayList();
    private boolean checkListPanelFilled = false;

    protected void save() {
        Iterator iterator = this.singleCheckPanels.iterator();
        while (iterator.hasNext()) {
            SingleCheckPanel singleCheckPanel = (SingleCheckPanel)iterator.next();
            singleCheckPanel.save();
        }
    }

    public boolean next() {
        this.save();
        return super.next();
    }

    public void willActivate() {
        super.willActivate();
        if (!this.checkListPanelFilled) {
            this.checkListPanelFilled = true;
            this.fillChecklistPanel();
        }
    }

    public boolean handleUnattended() {
        this.setupControls();
        this.fillChecklistPanel();
        this.save();
        return true;
    }

    public boolean handleConsole(Console console) throws UserCanceledException {
        if (!super.handleConsole(console)) {
            return false;
        }
        this.setupControls();
        this.fillChecklistPanel();
        console.println(this.getSubTitle());
        Iterator iterator = this.singleCheckPanels.iterator();
        while (iterator.hasNext()) {
            SingleCheckPanel singleCheckPanel = (SingleCheckPanel)iterator.next();
            singleCheckPanel.handleConsole(console);
        }
        this.save();
        return true;
    }

    protected void printDescription(Console console) {
        console.println(this.getSubTitle());
    }

    protected void setupControls() {
        super.setupControls();
        this.checklistPanel = new JPanel();
        this.scpChecklist = new JScrollPane(this.checklistPanel);
        JScrollBar jScrollBar = this.scpChecklist.getVerticalScrollBar();
        jScrollBar.setUnitIncrement(10);
        jScrollBar.setBlockIncrement(50);
        JScrollBar jScrollBar2 = this.scpChecklist.getHorizontalScrollBar();
        jScrollBar2.setUnitIncrement(10);
        jScrollBar2.setBlockIncrement(50);
        this.scpChecklist.setBorder(null);
        this.scpChecklist.setViewportBorder(null);
    }

    protected void addScreenContent(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.scpChecklist, gridBagConstraints);
    }

    private void fillChecklistPanel() {
        this.checklistPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.addSingleChecks(gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.checklistPanel.add((Component)new JPanel(), gridBagConstraints);
    }

    protected abstract void addSingleChecks(GridBagConstraints var1);

    protected abstract class SingleCheckPanel
    extends JPanel {
        protected JCheckBox chkSingle;

        protected SingleCheckPanel() {
        }

        public void save() {
        }

        public void handleConsole(Console console) throws UserCanceledException {
            if (this.chkSingle != null) {
                this.chkSingle.setSelected(console.askYesNo(this.chkSingle.getText(), this.chkSingle.isSelected()));
            }
        }
    }
}

