/*
   Copyright (C) 2008, 2010, 2011, 2012 Glad Deschrijver
     <glad.deschrijver@gmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 3 or later as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef LOGHIGHLIGHTER_H
#define LOGHIGHLIGHTER_H

#include <QtGui/QSyntaxHighlighter>

class QTextDocument;
class QColor;

class LogHighlighter : public QSyntaxHighlighter
{
	Q_OBJECT

public:
	LogHighlighter(QTextDocument *parent = 0);

protected:
	void highlightBlock(const QString &text);

private:
	QColor m_colorStandard;
	QColor m_colorFile;
	QColor m_colorError;
	QColor m_colorWarning;
	QColor m_colorPluginMessages;
};

#endif // LOGHIGHLIGHTER_H
