/*
   Copyright (C) 2008, 2010, 2011, 2012 Glad Deschrijver
     <glad.deschrijver@gmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 3 or later as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include "loghighlighter.h"

#include <QtGui/QColor>
#include <kcolorscheme.h>

LogHighlighter::LogHighlighter(QTextDocument *parent)
    : QSyntaxHighlighter(parent)
{
	const KColorScheme colorScheme(QPalette::Active, KColorScheme::View);
	m_colorStandard = colorScheme.foreground(KColorScheme::NormalText).color();
	m_colorFile = colorScheme.foreground(KColorScheme::LinkText).color();
	m_colorError = colorScheme.foreground(KColorScheme::NegativeText).color();
	m_colorWarning = colorScheme.foreground(KColorScheme::NeutralText).color();
	m_colorPluginMessages = colorScheme.foreground(KColorScheme::ActiveText).color();
}

void LogHighlighter::highlightBlock(const QString &text)
{
	// highlight (pdf)latex messages
	const QRegExp rxLatexError("! (.*)");
	const QRegExp rxBadBox("(Over|Under)(full \\\\[hv]box .*)");
	const QRegExp rxWarning("(((! )?(La|pdf)TeX)|Package) .*Warning.*:(.*)");

	if (rxLatexError.indexIn(text) != -1)
	{
		setFormat(0, text.length(), m_colorError);
	}
	else if (rxBadBox.indexIn(text) != -1 || rxWarning.indexIn(text) != -1)
	{
		setFormat(0, text.length(), m_colorWarning);
	}
	else if (text.indexOf(".tex", 0) != -1)
	{
		setFormat(0, text.length(), m_colorFile);
	}

	// highlight our own messages
	const QRegExp rxPluginMessages("^\\[[^\\]\\d][^\\]]*\\]"); // match [...] but not when ... is a page number or empty
	if (rxPluginMessages.indexIn(text) >= 0)
	{
		QTextCharFormat pluginMessagesFormat;
		pluginMessagesFormat.setForeground(m_colorPluginMessages);
		pluginMessagesFormat.setFontWeight(QFont::Bold);
		const int length = rxPluginMessages.matchedLength();
		setFormat(0, length, pluginMessagesFormat); // our messages always start with [...] at position 0
		setFormat(length, text.length(), m_colorStandard); // make sure that the text doesn't have the color m_colorFile (this can happen if the message contains ".tex", see above)
	}
}
