/*
   Copyright (C) 2008, 2010, 2011, 2013 Glad Deschrijver
     <glad.deschrijver@gmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 3 or later as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef KATE_LATEX_THREAD_H
#define KATE_LATEX_THREAD_H

#include <QtCore/QThread>
#include <QtCore/QMutex>
#include <QtCore/QStringList>

namespace Kate {
	class MainWindow;
}
class KProcess;
class KTextEdit;

struct LatexError {
	QString file;
	QString type;
	int line;
	QString message;
	int logLine;
};

class KateLatexThread : public QThread
{
	Q_OBJECT

public:
	KateLatexThread(Kate::MainWindow *mw, QWidget *parent);
	~KateLatexThread();
	void setOutputBox(KTextEdit *edit);
	void runTool(int which);
	void readConfig();

public slots:
	void abortProcess();
	void nextError();
	void previousError();

Q_SIGNALS:
	void outputClear();
	void outputSetCursorPosition(int line, int column);
	void outputAppendText(const QString &text);
	void outputInsertText(const QString &text);
	void processRunning(bool isRunning);
	void goToLineInFile(const QString &fileName, int lineNumber);

private Q_SLOTS:
	void readFromStandardOutput();

private:
	bool checkLogForRegExp(const QString &regExp, int startLine = 0);
	bool checkRerun(int startLine = 0);
	bool checkRunBibtex(const QString &bblFile);
	bool checkRunMakeindex(const QString &texFile, const QString &indFile);
	bool runCommand(const QString &toolName, const QString &command, const QStringList &optionList, const QString &workingDir, bool runDetached = false);
	void run();
	void goToError(bool goToNext);
	void findLatexErrors();

	Kate::MainWindow *m_mw;
	KTextEdit *m_kateLatexEdit;

	QString m_latexCommand, m_latexOptions;
	QString m_bibtexCommand, m_bibtexOptions;
	QString m_makeindexCommand, m_makeindexOptions;
	bool m_autoRerun;
	QString m_viewerCommand, m_viewerOptions;
	bool m_autoRunViewer;
	int m_whichTool;

	KProcess *m_proc;
	mutable QMutex m_memberLock;
	bool m_processAborted;

	int m_latexErrorIndex;
	QList<LatexError> m_latexErrorList;
};

#endif // KATE_LATEX_THREAD_H
