/*
   Copyright (C) 2008, 2010, 2011, 2013 Glad Deschrijver
     <glad.deschrijver@gmail.com>

   Based on the kate konsole plugin which is part of the KDE project
   and written by:
   Copyright (C) 2001 Christoph Cullmann <cullmann@kde.org>
   Copyright (C) 2002 Joseph Wenninger <jowenn@kde.org>
   Copyright (C) 2002 Anders Lund <anders.lund@lund.tdcadsl.dk>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 3 or later as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef KATE_LATEX_PLUGIN_H
#define KATE_LATEX_PLUGIN_H

#include <kate/plugin.h>
#include <kate/pluginconfigpageinterface.h>

class KateLatex;
class KateLatexPluginView;

class KateLatexPlugin: public Kate::Plugin, public Kate::PluginConfigPageInterface
{
	Q_OBJECT
	Q_INTERFACES(Kate::PluginConfigPageInterface)

public:
	explicit KateLatexPlugin(QObject *parent = 0, const QList<QVariant>& = QList<QVariant>());
	virtual ~KateLatexPlugin() {}

	Kate::PluginView *createView(Kate::MainWindow *mainWindow);

	// PluginConfigPageInterface
	uint configPages() const
	{
		return 1;
	}
	Kate::PluginConfigPage *configPage(uint number = 0, QWidget *parent = 0, const char *name = 0);
	QString configPageName(uint number = 0) const;
	QString configPageFullName(uint number = 0) const;
	KIcon configPageIcon(uint number = 0) const;

	void readConfig();

private:
	QList<KateLatexPluginView*> mViews;
};

class KateLatexPluginView : public Kate::PluginView
{
	Q_OBJECT

public:
	KateLatexPluginView(Kate::MainWindow *mainWindow);
	~KateLatexPluginView();
	void readConfig();

private:
	KateLatex *m_latexView;
};

#endif // KATE_LATEX_PLUGIN_H
