/*
   Copyright (C) 2008, 2010, 2011, 2012, 2013 Glad Deschrijver
     <glad.deschrijver@gmail.com>

   Based on the kate konsole plugin which is part of the KDE project
   and written by:
   Copyright (C) 2001 Christoph Cullmann <cullmann@kde.org>
   Copyright (C) 2002 Joseph Wenninger <jowenn@kde.org>
   Copyright (C) 2002 Anders Lund <anders.lund@lund.tdcadsl.dk>
   Copyright (C) 2007 Anders Lund <anders@alweb.dk>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 3 or later as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include "katelatexplugin.h"
#include "katelatexplugin.moc"

#include <KAboutData>
#include <KPluginFactory>

#include <kate/mainwindow.h>

#include "katelatex.h"
#include "katelatexconfigpage.h"

//#include <kauthorized.h>
//#include <kmessagebox.h>

K_PLUGIN_FACTORY(KateLatexPluginFactory, registerPlugin<KateLatexPlugin>();)
K_EXPORT_PLUGIN(KateLatexPluginFactory(KAboutData("katelatex", "katelatexplugin", ki18n("LaTeX Plugin"), KATELATEXPLUGINVERSION, ki18n("Simple plugin for typesetting (La)TeX documents"), KAboutData::License_GPL_V3)))

KateLatexPlugin::KateLatexPlugin(QObject *parent, const QList<QVariant>&)
    : Kate::Plugin((Kate::Application*)parent)
{
/*
  if (!KAuthorized::authorizeKAction("shell_access"))
  {
    KMessageBox::sorry(0, i18n("You do not have enough karma to access a shell or terminal emulation"));
  }
*/
}

Kate::PluginView *KateLatexPlugin::createView(Kate::MainWindow *mainWindow)
{
	KateLatexPluginView *view = new KateLatexPluginView(mainWindow);
	mViews.append(view);
	return view;
}

Kate::PluginConfigPage *KateLatexPlugin::configPage(uint number, QWidget *parent, const char *name)
{
	Q_UNUSED(name)
	if (number != 0)
		return 0;
	return new KateLatexConfigPage(parent, this);
}

QString KateLatexPlugin::configPageName(uint number) const
{
	if (number != 0)
		return QString();
	return i18n("LaTeX");
}

QString KateLatexPlugin::configPageFullName(uint number) const
{
	if (number != 0)
		return QString();
	return i18n("LaTeX settings");
}

KIcon KateLatexPlugin::configPageIcon(uint number) const
{
	if (number != 0)
		return KIcon();
	return KIcon("system-run");
}

void KateLatexPlugin::readConfig()
{
	foreach (KateLatexPluginView *view, mViews)
		view->readConfig();
}


/********************************************************************/


KateLatexPluginView::KateLatexPluginView(Kate::MainWindow *mainWindow)
    : Kate::PluginView(mainWindow)
{
	// init LaTeX view
	QWidget *toolview = mainWindow->createToolView("kate_private_plugin_katelatexplugin", Kate::MainWindow::Bottom, SmallIcon("run-build"), i18n("LaTeX"));
	m_latexView = new KateLatex(mainWindow, KateLatexPluginFactory::componentData(), toolview);
}

KateLatexPluginView::~KateLatexPluginView()
{
	// cleanup, kill toolview
	QWidget *toolview = m_latexView->parentWidget();
	delete m_latexView;
	delete toolview;
}

void KateLatexPluginView::readConfig()
{
	m_latexView->readConfig();
}
