/*
   Copyright (C) 2008, 2010, 2011, 2012, 2013 Glad Deschrijver
     <glad.deschrijver@gmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 3 or later as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include "katelatexconfigpage.h"
//#include "katelatexconfigpage.moc"
#include "katelatexplugin.h"

KateLatexConfigPage::KateLatexConfigPage(QWidget *parent, KateLatexPlugin *plugin)
  : Kate::PluginConfigPage(parent)
  , m_plugin(plugin)
{
	ui.setupUi(this);

	connect(ui.latexCommandEdit, SIGNAL(textChanged(QString)), SIGNAL(changed()));
	connect(ui.latexOptionsEdit, SIGNAL(textChanged(QString)), SIGNAL(changed()));
	connect(ui.bibtexCommandEdit, SIGNAL(textChanged(QString)), SIGNAL(changed()));
	connect(ui.bibtexOptionsEdit, SIGNAL(textChanged(QString)), SIGNAL(changed()));
	connect(ui.makeindexCommandEdit, SIGNAL(textChanged(QString)), SIGNAL(changed()));
	connect(ui.makeindexOptionsEdit, SIGNAL(textChanged(QString)), SIGNAL(changed()));
	connect(ui.autoRerunCheck, SIGNAL(stateChanged(int)), SIGNAL(changed()));
	connect(ui.viewerCommandEdit, SIGNAL(textChanged(QString)), SIGNAL(changed()));
	connect(ui.viewerOptionsEdit, SIGNAL(textChanged(QString)), SIGNAL(changed()));
	connect(ui.autoRunViewerCheck, SIGNAL(stateChanged(int)), SIGNAL(changed()));
	connect(ui.textFontEdit, SIGNAL(fontSelected(QFont)), SIGNAL(changed()));
	connect(ui.autoShowMessageBoxCheck, SIGNAL(stateChanged(int)), SIGNAL(changed()));

	reset();
}

void KateLatexConfigPage::apply()
{
	KConfigGroup config(KGlobal::config(), "LaTeX Plugin");
	config.writeEntry("LatexCommand", ui.latexCommandEdit->text());
	config.writeEntry("LatexOptions", ui.latexOptionsEdit->text());
	config.writeEntry("BibtexCommand", ui.bibtexCommandEdit->text());
	config.writeEntry("BibtexOptions", ui.bibtexOptionsEdit->text());
	config.writeEntry("MakeindexCommand", ui.makeindexCommandEdit->text());
	config.writeEntry("MakeindexOptions", ui.makeindexOptionsEdit->text());
	config.writeEntry("AutoRerun", ui.autoRerunCheck->isChecked());
	config.writeEntry("ViewerCommand", ui.viewerCommandEdit->text());
	config.writeEntry("ViewerOptions", ui.viewerOptionsEdit->text());
	config.writeEntry("AutoRunViewer", ui.autoRunViewerCheck->isChecked());
	config.writeEntry("Font", ui.textFontEdit->font().toString());
	config.writeEntry("AutoShowMessageBox", ui.autoShowMessageBoxCheck->isChecked());
	config.sync();
	m_plugin->readConfig();
}

void KateLatexConfigPage::reset()
{
	// same defaults as in KateLatexThread::readConfig()
	KConfigGroup config(KGlobal::config(), "LaTeX Plugin");
	ui.latexCommandEdit->setText(config.readEntry("LatexCommand", "pdflatex"));
	ui.latexOptionsEdit->setText(config.readEntry("LatexOptions", "--synctex=1 --interaction=nonstopmode %.tex"));
	ui.bibtexCommandEdit->setText(config.readEntry("BibtexCommand", "bibtex"));
	ui.bibtexOptionsEdit->setText(config.readEntry("BibtexOptions", "%.aux"));
	ui.makeindexCommandEdit->setText(config.readEntry("MakeindexCommand", "makeindex"));
	ui.makeindexOptionsEdit->setText(config.readEntry("MakeindexOptions", "%.idx"));
	ui.autoRerunCheck->setChecked(config.readEntry("AutoRerun", true));
	ui.viewerCommandEdit->setText(config.readEntry("ViewerCommand", "okular"));
	ui.viewerOptionsEdit->setText(config.readEntry("ViewerOptions", "--unique \"file:%.pdf#src:@ %.tex\""));
	ui.autoRunViewerCheck->setChecked(config.readEntry("AutoRunViewer", true));
	QFont textFont;
	textFont.fromString(config.readEntry("Font", qApp->font().toString()));
	ui.textFontEdit->setFont(textFont);
	ui.autoShowMessageBoxCheck->setChecked(config.readEntry("AutoShowMessageBox", true));
}
