/*
   Copyright (C) 2008, 2010, 2011, 2013 Glad Deschrijver
     <glad.deschrijver@gmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 3 or later as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef KATE_LATEX_H
#define KATE_LATEX_H

#include <kate/plugin.h>

#include <KVBox>
#include <KXMLGUIClient>

class KAction;
class KTextEdit;
class KToolBar;
namespace Kate {
	class MainWindow;
}

class KateLatexThread;

/**
 * KateLatex
 * This class is used for the LaTeX output view
 */
class KateLatex : public KVBox, public Kate::XMLGUIClient
{
	Q_OBJECT

public:
	KateLatex(Kate::MainWindow *mw, const KComponentData &componentData, QWidget *parent);
	~KateLatex();
	void readConfig();

	Kate::MainWindow *mainWindow()
	{
		return m_mw;
	}

public Q_SLOTS:
	void runTool();

private Q_SLOTS:
	void outputClear();
	void outputSetCursorPosition(int line, int column);
	void outputAppendText(const QString &text);
//	void slotToggleFocus();
	void setProcessRunning(bool isRunning);
	void goToLineInFile(const QString &fileName, int lineNumber);

protected:
	void keyPressEvent(QKeyEvent *event);

private:
	KToolBar *logToolBar(QWidget *parent = 0);

	KateLatexThread *m_kateLatexThread;

	Kate::MainWindow *m_mw;
	QWidget *m_toolView;
	KTextEdit *m_kateLatexEdit;
	KAction *m_procStopAction;

	bool m_autoShowMessageBox;
};

#endif // KATE_LATEX_H
