include(InstallRequiredSystemLibraries)
set(CPACK_PACKAGE_NAME ${CMAKE_PROJECT_NAME})
set(CPACK_PACKAGE_DESCRIPTION_SUMMARY "Kate LaTeX Plugin is a plugin which allows you to typeset (La)TeX documents from within Kate")
set(CPACK_PACKAGE_VENDOR "Glad Deschrijver")
set(CPACK_PACKAGE_VERSION ${KATELATEXPLUGIN_VERSION})
string(REGEX REPLACE "\\..*" "" CPACK_PACKAGE_VERSION_MAJOR ${CPACK_PACKAGE_VERSION})
string(REGEX REPLACE "([0-9]*)\\.([0-9]*)(\\.([0-9]*))?" "\\2" CPACK_PACKAGE_VERSION_MINOR ${CPACK_PACKAGE_VERSION})
string(REGEX REPLACE "([0-9]*)\\.([0-9]*)(\\.)?" "" CPACK_PACKAGE_VERSION_PATCH ${CPACK_PACKAGE_VERSION})
if("${CPACK_PACKAGE_VERSION_PATCH}" STREQUAL "") # if ${CPACK_PACKAGE_VERSION} is of the form 0.10 instead of 0.10.3
	set(CPACK_PACKAGE_VERSION_PATCH "0")
endif("${CPACK_PACKAGE_VERSION_PATCH}" STREQUAL "")
set(CPACK_PACKAGE_DESCRIPTION_FILE "${CMAKE_CURRENT_SOURCE_DIR}/README")
set(CPACK_PACKAGE_INSTALL_DIRECTORY "KateLaTeXPlugin ${CPACK_PACKAGE_VERSION}")
set(CPACK_RESOURCE_FILE_README "${CMAKE_CURRENT_SOURCE_DIR}/README")
set(CPACK_RESOURCE_FILE_LICENSE "${CMAKE_CURRENT_SOURCE_DIR}/LICENSE.GPL3")
set(CPACK_SOURCE_GENERATOR "TBZ2")
set(CPACK_SOURCE_IGNORE_FILES "/.svn/;/build*/*;Makefile;~$;snapshot*")
set(CPACK_SOURCE_PACKAGE_FILE_NAME "${CMAKE_PROJECT_NAME}-${CPACK_PACKAGE_VERSION}")
set(CPACK_SET_DESTDIR TRUE)
if(WIN32 AND NOT UNIX)
	# There is a bug in NSI that does not handle full unix paths properly. Make
	# sure there is at least one set of four (4) backslashes.
#	set(CPACK_PACKAGE_ICON "${CMake_SOURCE_DIR}/Utilities/Release\\\\InstallIcon.bmp")
	set(CPACK_PACKAGE_INSTALL_REGISTRY_KEY "KateLatexPlugin ${CPACK_PACKAGE_VERSION}")
	set(CPACK_NSIS_INSTALLED_ICON_NAME "lib\\\\katelatexplugin.dll")
	set(CPACK_NSIS_DISPLAY_NAME "${CPACK_PACKAGE_INSTALL_DIRECTORY} KateLatexPlugin")
	set(CPACK_NSIS_HELP_LINK "http:\\\\\\\\kde-apps.org/content/show.php/Kate+LaTeX+typesetting+plugin?content=84772")
	set(CPACK_NSIS_URL_INFO_ABOUT "http:\\\\\\\\kde-apps.org/content/show.php/Kate+LaTeX+typesetting+plugin?content=84772")
	set(CPACK_NSIS_CONTACT "glad.deschrijver@gmail.com")
	set(CPACK_NSIS_MODIFY_PATH ON)
else(WIN32 AND NOT UNIX)
	set(CPACK_STRIP_FILES "lib/katelatexplugin")
	set(CPACK_SOURCE_STRIP_FILES "")
endif(WIN32 AND NOT UNIX)
#set(CPACK_PACKAGE_EXECUTABLES "katelatexplugin;KateLatexPlugin")
#execute_process(COMMAND dpkg --print-architecture OUTPUT_VARIABLE DEBIAN_PACKAGE_ARCHITECTURE)
#set(CPACK_DEBIAN_PACKAGE_ARCHITECTURE ${DEBIAN_PACKAGE_ARCHITECTURE})
set(CPACK_DEBIAN_PACKAGE_DEPENDS "libkatepartinterfaces4 (>=4.3.0)")
set(CPACK_DEBIAN_PACKAGE_MAINTAINER "Glad Deschrijver <glad.deschrijver@gmail.com>")
set(CPACK_DEBIAN_PACKAGE_SECTION "editors")
#set(CPACK_DEBIAN_PACKAGE_PRIORITY "optional")
