/*
GanttProject is an opensource project management tool.
Copyright (C) 2003-2011 GanttProject Team

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 3
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.sourceforge.ganttproject.gui;

import java.io.File;

import javax.swing.JFileChooser;

import net.sourceforge.ganttproject.filter.GanttXMLFileFilter;

/**
 * Open A dialog box to select an GanttProject or XML
 * 
 * The current directory is stored, when the user selected a file
 */
public class OpenFileDialog {

  private final JFileChooser myFileChooser;

  public OpenFileDialog() {
    this(System.getProperty("user.home"));
  }

  public OpenFileDialog(String startDirectory) {
    File f = new File(startDirectory);
    if (!f.isDirectory()) {
      f = f.getParentFile();
    }
    myFileChooser = new JFileChooser(f);
    myFileChooser.addChoosableFileFilter(new GanttXMLFileFilter());
  }

  /**
   * Show the dialog box
   * 
   * @return the selected file, or null if the user aborted
   */
  public File show() {
    File result = null;

    int returnVal = myFileChooser.showOpenDialog(null);
    if (returnVal == JFileChooser.APPROVE_OPTION) {
      result = myFileChooser.getSelectedFile();
    }
    return result;
  }
}
