/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.appbundler;

import com.oracle.appbundler.Argument;
import com.oracle.appbundler.Option;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class AppBundlerTask
extends Task {
    private File outputDirectory = null;
    private String name = null;
    private String displayName = null;
    private String identifier = null;
    private File icon = null;
    private String shortVersion = "1.0";
    private String signature = "????";
    private String copyright = "";
    private String applicationCategory = null;
    private String mainClassName = null;
    private FileSet runtime = null;
    private ArrayList<FileSet> classPath = new ArrayList();
    private ArrayList<FileSet> libraryPath = new ArrayList();
    private ArrayList<String> options = new ArrayList();
    private ArrayList<String> arguments = new ArrayList();
    private static final String EXECUTABLE_NAME = "JavaAppLauncher";
    private static final String DEFAULT_ICON_NAME = "GenericApp.icns";
    private static final String OS_TYPE_CODE = "APPL";
    private static final String PLIST_DTD = "<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">";
    private static final String PLIST_TAG = "plist";
    private static final String PLIST_VERSION_ATTRIBUTE = "version";
    private static final String DICT_TAG = "dict";
    private static final String KEY_TAG = "key";
    private static final String ARRAY_TAG = "array";
    private static final String STRING_TAG = "string";
    private static final int BUFFER_SIZE = 2048;

    public void setOutputDirectory(File file) {
        this.outputDirectory = file;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public void setIdentifier(String string) {
        this.identifier = string;
    }

    public void setIcon(File file) {
        this.icon = file;
    }

    public void setShortVersion(String string) {
        this.shortVersion = string;
    }

    public void setSignature(String string) {
        this.signature = string;
    }

    public void setCopyright(String string) {
        this.copyright = string;
    }

    public void setApplicationCategory(String string) {
        this.applicationCategory = string;
    }

    public void setMainClassName(String string) {
        this.mainClassName = string;
    }

    public void addConfiguredRuntime(FileSet fileSet) throws BuildException {
        if (this.runtime != null) {
            throw new BuildException("Runtime already specified.");
        }
        this.runtime = fileSet;
        fileSet.appendIncludes(new String[]{"jre/"});
        fileSet.appendExcludes(new String[]{"bin/", "jre/bin/", "jre/lib/deploy/", "jre/lib/deploy.jar", "jre/lib/javaws.jar", "jre/lib/libdeploy.dylib", "jre/lib/libnpjp2.dylib", "jre/lib/plugin.jar", "jre/lib/security/javaws.policy"});
    }

    public void addConfiguredClassPath(FileSet fileSet) {
        this.classPath.add(fileSet);
    }

    public void addConfiguredLibraryPath(FileSet fileSet) {
        this.libraryPath.add(fileSet);
    }

    public void addConfiguredOption(Option option) throws BuildException {
        String string = option.getValue();
        if (string == null) {
            throw new BuildException("Value is required.");
        }
        this.options.add(string);
    }

    public void addConfiguredArgument(Argument argument) throws BuildException {
        String string = argument.getValue();
        if (string == null) {
            throw new BuildException("Value is required.");
        }
        this.arguments.add(string);
    }

    public void execute() throws BuildException {
        if (this.outputDirectory == null) {
            throw new IllegalStateException("Output directory is required.");
        }
        if (!this.outputDirectory.exists()) {
            throw new IllegalStateException("Output directory does not exist.");
        }
        if (!this.outputDirectory.isDirectory()) {
            throw new IllegalStateException("Invalid output directory.");
        }
        if (this.name == null) {
            throw new IllegalStateException("Name is required.");
        }
        if (this.displayName == null) {
            throw new IllegalStateException("Display name is required.");
        }
        if (this.identifier == null) {
            throw new IllegalStateException("Identifier is required.");
        }
        if (this.icon != null) {
            if (!this.icon.exists()) {
                throw new IllegalStateException("Icon does not exist.");
            }
            if (this.icon.isDirectory()) {
                throw new IllegalStateException("Invalid icon.");
            }
        }
        if (this.shortVersion == null) {
            throw new IllegalStateException("Short version is required.");
        }
        if (this.signature == null) {
            throw new IllegalStateException("Signature is required.");
        }
        if (this.signature.length() != 4) {
            throw new IllegalStateException("Invalid signature.");
        }
        if (this.copyright == null) {
            throw new IllegalStateException("Copyright is required.");
        }
        if (this.mainClassName == null) {
            throw new IllegalStateException("Main class name is required.");
        }
        try {
            System.out.println("Creating app bundle: " + this.name);
            File file = new File(this.outputDirectory, this.name + ".app");
            AppBundlerTask.delete(file);
            file.mkdir();
            File file2 = new File(file, "Contents");
            file2.mkdir();
            File file3 = new File(file2, "MacOS");
            file3.mkdir();
            File file4 = new File(file2, "Java");
            file4.mkdir();
            File file5 = new File(file2, "PlugIns");
            file5.mkdir();
            File file6 = new File(file2, "Resources");
            file6.mkdir();
            File file7 = new File(file2, "Info.plist");
            file7.createNewFile();
            this.writeInfoPlist(file7);
            File file8 = new File(file2, "PkgInfo");
            file8.createNewFile();
            this.writePkgInfo(file8);
            File file9 = new File(file3, EXECUTABLE_NAME);
            AppBundlerTask.copy(((Object)((Object)this)).getClass().getResource(file9.getName()), file9);
            file9.setExecutable(true, false);
            this.copyResources(file6);
            this.copyRuntime(file5);
            this.copyClassPathEntries(file4);
            this.copyLibraryPathEntries(file3);
            this.copyIcon(file6);
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResources(File file) throws IOException {
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("res.zip");
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        try {
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                File file2 = new File(file, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    file2.mkdir();
                } else {
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2), 2048);
                    try {
                        int n = zipInputStream.read();
                        while (n != -1) {
                            ((OutputStream)bufferedOutputStream).write(n);
                            n = zipInputStream.read();
                        }
                        ((OutputStream)bufferedOutputStream).flush();
                    }
                    finally {
                        ((OutputStream)bufferedOutputStream).close();
                    }
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        finally {
            zipInputStream.close();
        }
    }

    private void copyRuntime(File file) throws IOException {
        if (this.runtime != null) {
            File file2 = this.runtime.getDir();
            File file3 = file2.getParentFile();
            File file4 = file3.getParentFile();
            File file5 = new File(file, file4.getName());
            file5.mkdir();
            File file6 = new File(file5, file3.getName());
            file6.mkdir();
            File file7 = new File(file3, "Info.plist");
            AppBundlerTask.copy(file7, new File(file6, file7.getName()));
            File file8 = new File(file6, file2.getName());
            DirectoryScanner directoryScanner = this.runtime.getDirectoryScanner(this.getProject());
            String[] stringArray = directoryScanner.getIncludedFiles();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                File file9 = new File(file2, string);
                File file10 = new File(file8, string);
                AppBundlerTask.copy(file9, file10);
            }
        }
    }

    private void copyClassPathEntries(File file) throws IOException {
        for (FileSet fileSet : this.classPath) {
            File file2 = fileSet.getDir();
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            String[] stringArray = directoryScanner.getIncludedFiles();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                File file3 = new File(file2, string);
                File file4 = new File(file, new File(string).getName());
                AppBundlerTask.copy(file3, file4);
            }
        }
    }

    private void copyLibraryPathEntries(File file) throws IOException {
        for (FileSet fileSet : this.libraryPath) {
            File file2 = fileSet.getDir();
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            String[] stringArray = directoryScanner.getIncludedFiles();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                File file3 = new File(file2, string);
                File file4 = new File(file, new File(string).getName());
                AppBundlerTask.copy(file3, file4);
            }
        }
    }

    private void copyIcon(File file) throws IOException {
        if (this.icon == null) {
            AppBundlerTask.copy(((Object)((Object)this)).getClass().getResource(DEFAULT_ICON_NAME), new File(file, DEFAULT_ICON_NAME));
        } else {
            AppBundlerTask.copy(this.icon, new File(file, this.icon.getName()));
        }
    }

    private void writeInfoPlist(File file) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
        try {
            XMLStreamWriter xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter(bufferedWriter);
            xMLStreamWriter.writeStartDocument();
            xMLStreamWriter.writeCharacters("\n");
            xMLStreamWriter.writeDTD(PLIST_DTD);
            xMLStreamWriter.writeCharacters("\n");
            xMLStreamWriter.writeStartElement(PLIST_TAG);
            xMLStreamWriter.writeAttribute(PLIST_VERSION_ATTRIBUTE, "1.0");
            xMLStreamWriter.writeCharacters("\n");
            xMLStreamWriter.writeStartElement(DICT_TAG);
            xMLStreamWriter.writeCharacters("\n");
            this.writeProperty(xMLStreamWriter, "CFBundleDevelopmentRegion", "English");
            this.writeProperty(xMLStreamWriter, "CFBundleExecutable", EXECUTABLE_NAME);
            this.writeProperty(xMLStreamWriter, "CFBundleIconFile", this.icon == null ? DEFAULT_ICON_NAME : this.icon.getName());
            this.writeProperty(xMLStreamWriter, "CFBundleIdentifier", this.identifier);
            this.writeProperty(xMLStreamWriter, "CFBundleDisplayName", this.displayName);
            this.writeProperty(xMLStreamWriter, "CFBundleInfoDictionaryVersion", "6.0");
            this.writeProperty(xMLStreamWriter, "CFBundleName", this.name);
            this.writeProperty(xMLStreamWriter, "CFBundlePackageType", OS_TYPE_CODE);
            this.writeProperty(xMLStreamWriter, "CFBundleShortVersionString", this.shortVersion);
            this.writeProperty(xMLStreamWriter, "CFBundleSignature", this.signature);
            this.writeProperty(xMLStreamWriter, "CFBundleVersion", "1");
            this.writeProperty(xMLStreamWriter, "NSHumanReadableCopyright", this.copyright);
            if (this.applicationCategory != null) {
                this.writeProperty(xMLStreamWriter, "LSApplicationCategoryType", this.applicationCategory);
            }
            if (this.runtime != null) {
                this.writeProperty(xMLStreamWriter, "JVMRuntime", this.runtime.getDir().getParentFile().getParentFile().getName());
            }
            this.writeProperty(xMLStreamWriter, "JVMMainClassName", this.mainClassName);
            this.writeKey(xMLStreamWriter, "JVMOptions");
            xMLStreamWriter.writeStartElement(ARRAY_TAG);
            xMLStreamWriter.writeCharacters("\n");
            for (String string : this.options) {
                this.writeString(xMLStreamWriter, string);
            }
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeCharacters("\n");
            this.writeKey(xMLStreamWriter, "JVMArguments");
            xMLStreamWriter.writeStartElement(ARRAY_TAG);
            xMLStreamWriter.writeCharacters("\n");
            for (String string : this.arguments) {
                this.writeString(xMLStreamWriter, string);
            }
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeCharacters("\n");
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeCharacters("\n");
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeCharacters("\n");
            xMLStreamWriter.writeEndDocument();
            xMLStreamWriter.writeCharacters("\n");
            ((Writer)bufferedWriter).flush();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new IOException(xMLStreamException);
        }
        finally {
            ((Writer)bufferedWriter).close();
        }
    }

    private void writeKey(XMLStreamWriter xMLStreamWriter, String string) throws XMLStreamException {
        xMLStreamWriter.writeStartElement(KEY_TAG);
        xMLStreamWriter.writeCharacters(string);
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeCharacters("\n");
    }

    private void writeString(XMLStreamWriter xMLStreamWriter, String string) throws XMLStreamException {
        xMLStreamWriter.writeStartElement(STRING_TAG);
        xMLStreamWriter.writeCharacters(string);
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeCharacters("\n");
    }

    private void writeProperty(XMLStreamWriter xMLStreamWriter, String string, String string2) throws XMLStreamException {
        this.writeKey(xMLStreamWriter, string);
        this.writeString(xMLStreamWriter, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePkgInfo(File file) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        try {
            bufferedWriter.write(OS_TYPE_CODE + this.signature);
            ((Writer)bufferedWriter).flush();
        }
        finally {
            ((Writer)bufferedWriter).close();
        }
    }

    private static void delete(File file) throws IOException {
        Path path = file.toPath();
        if (Files.exists(path, LinkOption.NOFOLLOW_LINKS)) {
            if (Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    AppBundlerTask.delete(fileArray[i]);
                }
            }
            Files.delete(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(URL uRL, File file) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private static void copy(File file, File file2) throws IOException {
        Path path = file.toPath();
        Path path2 = file2.toPath();
        file2.getParentFile().mkdirs();
        Files.copy(path, path2, StandardCopyOption.REPLACE_EXISTING, LinkOption.NOFOLLOW_LINKS);
        if (Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                AppBundlerTask.copy(new File(file, string), new File(file2, string));
            }
        }
    }
}

