/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);
    public static final String PATTERN_WEBDAV = "yyyy-MM-dd HH:mm:ss";
    public static final String PATTERN_RESPONSE_HEADER = "E, dd MMM yyyy HH:mm:ss z";
    private static final ThreadLocal<DateFormat> thHeaderDateFormat = new ThreadLocal();
    public static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String PATTERN_RFC1123_HYPHENS = "EEE, dd-MMM-yyyy HH:mm:ss zzz";
    public static final String PATTERN_RFC1123_NOSECS = "EEE, dd MMM yyyy HH:mm zzz";
    public static final String PATTERN_RFC1036 = "EEEE, dd-MMM-yy HH:mm:ss zzz";
    public static final String PATTERN_ASCTIME = "EEE MMM d HH:mm:ss yyyy";
    public static final String PATTERN_ASCTIME2 = "EEE MMM yyyy HH:mm:ss zzz";
    private static final Collection<String> DEFAULT_PATTERNS = Arrays.asList("EEE MMM d HH:mm:ss yyyy", "EEE MMM yyyy HH:mm:ss zzz", "EEEE, dd-MMM-yy HH:mm:ss zzz", "EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd MMM yyyy HH:mm zzz", "yyyy-MM-dd HH:mm:ss");
    private static final Date DEFAULT_TWO_DIGIT_YEAR_START;
    public static final TimeZone GMT;
    private static final Pattern DATE_VALUE;

    public static Date parseWebDavDate(String s) throws DateParseException {
        if (!s.contains(" ")) {
            s = s.replace('Z', ' ');
            s = s.replace('T', ' ');
            s = s.trim();
        }
        return DateUtils.parseDate(s);
    }

    public static Date parseIcalDateTime(String s) throws DateParseException {
        Matcher m = DATE_VALUE.matcher(s);
        if (!m.matches()) {
            throw new DateParseException("Does not match regex: " + s);
        }
        int year = Integer.parseInt(m.group(1));
        int month = Integer.parseInt(m.group(2));
        int day = Integer.parseInt(m.group(3));
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        if (null != m.group(4)) {
            int hour = Integer.parseInt(m.group(4));
            int minute = Integer.parseInt(m.group(5));
            int second = Integer.parseInt(m.group(6));
            boolean utc = null != m.group(7);
            cal.set(10, hour);
            cal.set(12, minute);
            cal.set(13, second);
        }
        return cal.getTime();
    }

    public static Date parseDate(String dateValue) throws DateParseException {
        return DateUtils.parseDate(dateValue, null, null);
    }

    public static Date parseDate(String dateValue, Collection<String> dateFormats) throws DateParseException {
        return DateUtils.parseDate(dateValue, dateFormats, null);
    }

    public static Date parseDate(String dateValue, Collection<String> dateFormats, Date startDate) throws DateParseException {
        if (dateValue == null) {
            throw new IllegalArgumentException("dateValue is null");
        }
        if (dateFormats == null) {
            dateFormats = DEFAULT_PATTERNS;
        }
        if (startDate == null) {
            startDate = DEFAULT_TWO_DIGIT_YEAR_START;
        }
        if (dateValue.length() > 1 && dateValue.startsWith("'") && dateValue.endsWith("'")) {
            dateValue = dateValue.substring(1, dateValue.length() - 1);
        }
        SimpleDateFormat dateParser = null;
        for (String format : dateFormats) {
            if (dateParser == null) {
                dateParser = new SimpleDateFormat(format, Locale.US);
                dateParser.setTimeZone(TimeZone.getTimeZone("GMT"));
                dateParser.set2DigitYearStart(startDate);
            } else {
                dateParser.applyPattern(format);
            }
            try {
                Date dt = dateParser.parse(dateValue);
                return dt;
            }
            catch (ParseException pe) {
            }
        }
        throw new DateParseException("Unable to parse the date: " + dateValue);
    }

    public static String formatDate(Date date) {
        Calendar cal = Calendar.getInstance(GMT);
        cal.setTime(date);
        return DateUtils.formatDate(cal);
    }

    public static String formatDate(Calendar cal) {
        StringBuilder sb = new StringBuilder();
        sb.append(cal.get(1)).append("");
        sb.append('-');
        sb.append(DateUtils.pad2(cal.get(2) + 1));
        sb.append('-');
        sb.append(DateUtils.pad2(cal.get(5)));
        sb.append('T');
        sb.append(DateUtils.pad2(cal.get(11)));
        sb.append(':');
        sb.append(DateUtils.pad2(cal.get(12)));
        sb.append(':');
        sb.append(DateUtils.pad2(cal.get(13)));
        sb.append('Z');
        String s = sb.toString();
        return s;
    }

    public static String formatForHeader(Date date) {
        DateFormat df = thHeaderDateFormat.get();
        if (df == null) {
            df = new SimpleDateFormat(PATTERN_RESPONSE_HEADER);
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            thHeaderDateFormat.set(df);
        }
        return df.format(date);
    }

    public static String pad2(int i) {
        if (i < 10) {
            return "0" + i;
        }
        return i + "";
    }

    public static String formatDate(Date date, String pattern) {
        if (date == null) {
            throw new IllegalArgumentException("date is null");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("pattern is null");
        }
        SimpleDateFormat formatter = new SimpleDateFormat(pattern, Locale.US);
        formatter.setTimeZone(GMT);
        return formatter.format(date);
    }

    public static String formatForWebDavModifiedDate(Date date) {
        return DateUtils.formatDate(date, PATTERN_RFC1123);
    }

    public static String formatForCookieExpiry(Date date) {
        return DateUtils.formatDate(date, PATTERN_RFC1123_HYPHENS);
    }

    private DateUtils() {
    }

    static {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2000, 0, 1, 0, 0);
        DEFAULT_TWO_DIGIT_YEAR_START = calendar.getTime();
        GMT = TimeZone.getTimeZone("GMT");
        DATE_VALUE = Pattern.compile("(\\d{4,})(\\d\\d)(\\d\\d)(?:T([0-1]\\d|2[0-3])([0-5]\\d)([0-5]\\d)(Z)?)?");
    }

    public static class DateParseException
    extends Exception {
        static final long serialVersionUID = 4417696455000643370L;

        public DateParseException() {
        }

        public DateParseException(String message) {
            super(message);
        }
    }
}

