/*
 * Decompiled with CFR 0.152.
 */
package io.milton.event;

import io.milton.event.Event;
import io.milton.event.EventListener;
import io.milton.event.EventManager;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventManagerImpl
implements EventManager {
    private static final Logger log = LoggerFactory.getLogger(EventManagerImpl.class);
    private final List<Registration> registrations = new CopyOnWriteArrayList<Registration>();

    @Override
    public void fireEvent(Event e) {
        if (log.isTraceEnabled()) {
            log.trace("fireEvent: " + e.getClass().getCanonicalName());
        }
        for (Registration r : this.registrations) {
            if (!r.clazz.isAssignableFrom(e.getClass())) continue;
            if (log.isTraceEnabled()) {
                log.trace("  firing on: " + r.listener.getClass());
            }
            r.listener.onEvent(e);
        }
    }

    @Override
    public synchronized <T extends Event> void registerEventListener(EventListener l, Class<T> c) {
        log.info("registerEventListener: " + l.getClass().getCanonicalName() + " - " + c.getCanonicalName());
        Registration r = new Registration(l, c);
        this.registrations.add(r);
    }

    private class Registration {
        private final EventListener listener;
        private final Class<? extends Event> clazz;

        public Registration(EventListener listener, Class<? extends Event> clazz) {
            this.listener = listener;
            this.clazz = clazz;
        }
    }
}

