/*
 * Decompiled with CFR 0.152.
 */
package io.milton.context;

import io.milton.context.Context;
import io.milton.context.Factory;
import io.milton.context.Registration;
import io.milton.context.RootContext;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingletonFactory
implements Factory {
    private static final Logger log = LoggerFactory.getLogger(SingletonFactory.class);
    private Object bean;
    private Class[] keyClasses;

    @Override
    public Class[] keyClasses() {
        return this.keyClasses;
    }

    @Override
    public String[] keyIds() {
        return null;
    }

    public Registration insert(RootContext context, Context requestContext) {
        return context.put(this.bean);
    }

    @Override
    public void init(RootContext context) {
    }

    @Override
    public void destroy() {
        if (this.bean instanceof Closeable) {
            log.warn("closing: " + this.bean.getClass());
            Closeable c = (Closeable)this.bean;
            try {
                c.close();
            }
            catch (IOException ex) {
                log.error("Exception closing: " + this.bean.getClass(), (Throwable)ex);
            }
        } else {
            log.warn("not closing: " + this.bean.getClass());
        }
    }

    @Override
    public void onRemove(Object item) {
    }

    public String getBeanClass() {
        return this.bean.getClass().getCanonicalName();
    }

    public String getKeyClasses() {
        String s = "";
        for (Class c : this.keyClasses) {
            s = s + c.getCanonicalName() + ",";
        }
        return s;
    }

    public void setBean(Object bean) {
        this.bean = bean;
        ArrayList list = new ArrayList();
        list.add(bean.getClass());
        log.debug("setBean: " + bean.getClass().getCanonicalName());
        for (Class<?> c : this.bean.getClass().getInterfaces()) {
            list.add(c);
            log.debug(" - add interface: " + c.getCanonicalName());
        }
        for (Class<?> superClass = this.bean.getClass().getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            list.add(superClass);
        }
        this.keyClasses = new Class[list.size()];
        list.toArray(this.keyClasses);
    }

    public Object getBean() {
        return this.bean;
    }

    public String toString() {
        if (this.bean != null) {
            return "SingletonFactory(" + this.bean.getClass() + ")";
        }
        return super.toString();
    }
}

