/*
 * Decompiled with CFR 0.152.
 */
package io.milton.context;

import io.milton.context.ClassNotInContextException;
import io.milton.context.Context;
import io.milton.context.Registration;
import io.milton.context.RemovalCallback;
import io.milton.context.RootContext;
import java.util.ArrayList;

public class RequestContext
extends Context
implements RemovalCallback {
    private static final ThreadLocal<RequestContext> tlContext = new ThreadLocal();
    private RootContext parent;

    public static <T> T C(Class<T> c) throws ClassNotInContextException {
        T t = RequestContext.getCurrent().get(c);
        if (t == null) {
            throw new ClassNotInContextException(c);
        }
        return t;
    }

    @Deprecated
    public static <T> T _(Class<T> c) throws ClassNotInContextException {
        return RequestContext.C(c);
    }

    public static <T> T C(Class<T> c, boolean required) throws ClassNotInContextException {
        T t = RequestContext.getCurrent().get(c);
        if (t == null && required) {
            throw new ClassNotInContextException(c);
        }
        return t;
    }

    @Deprecated
    public static <T> T _(Class<T> c, boolean required) throws ClassNotInContextException {
        return RequestContext.C(c, required);
    }

    public static RequestContext getCurrent() {
        RequestContext c = tlContext.get();
        return c;
    }

    static void setCurrent(RequestContext rc) {
        if (rc == null) {
            tlContext.remove();
        } else {
            tlContext.set(rc);
        }
    }

    public static RequestContext getInstance(RootContext parent) {
        RequestContext c = RequestContext.getCurrent();
        if (c == null) {
            c = new RequestContext(parent);
            RequestContext.setCurrent(c);
        }
        return c;
    }

    public static RequestContext peekInstance() {
        return RequestContext.getCurrent();
    }

    private RequestContext(RootContext parent) {
        if (parent == null) {
            throw new IllegalArgumentException("parent cannot be null");
        }
        this.parent = parent;
    }

    public RootContext getRootContext() {
        return this.parent;
    }

    protected Registration getRegistration(Class c) {
        return this.getOrCreateRegistration(c, (Context)this);
    }

    protected Registration getRegistration(String id) {
        return this.getOrCreateRegistration(id, (Context)this);
    }

    @Override
    protected Registration getOrCreateRegistration(Class c, Context context) {
        Registration reg = super.getRegistration(c);
        if (reg != null) {
            return reg;
        }
        return this.parent.getOrCreateRegistration(c, (Context)this);
    }

    @Override
    Registration getOrCreateRegistration(String id, Context context) {
        Registration reg = super.getRegistration(id);
        if (reg != null) {
            return reg;
        }
        return this.parent.getRegistration(id);
    }

    public void onRemove(Object item) {
        tlContext.set(null);
        ArrayList items = new ArrayList(this.itemByClass.values());
        for (Registration reg : items) {
            reg.remove();
        }
    }
}

