/*
 * Decompiled with CFR 0.152.
 */
package io.milton.common;

import io.milton.common.ChunkWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ChunkingOutputStream
extends OutputStream {
    final ChunkWriter chunkWriter;
    final ByteArrayOutputStream chunkInProgress;
    final int chunkSize;
    private long count;
    private int currentChunk;

    public ChunkingOutputStream(ChunkWriter chunkWriter, int chunkSize) {
        this.chunkWriter = chunkWriter;
        this.chunkSize = chunkSize;
        this.chunkInProgress = new ByteArrayOutputStream(chunkSize);
    }

    @Override
    public void write(int b) throws IOException {
        ++this.count;
        if (this.chunkInProgress.size() >= this.chunkSize) {
            this.flushChunk();
        }
        this.chunkInProgress.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.chunkInProgress.size() >= this.chunkSize) {
            this.flushChunk();
        }
        this.count += (long)len;
        this.chunkInProgress.write(b, off, len);
    }

    private void flushChunk() {
        if (this.chunkInProgress.size() == 0) {
            return;
        }
        byte[] arr = this.chunkInProgress.toByteArray();
        this.chunkWriter.newChunk(this.currentChunk++, arr);
        this.chunkInProgress.reset();
    }

    @Override
    public void flush() throws IOException {
        this.flushChunk();
    }
}

