/*
 * Decompiled with CFR 0.152.
 */
package org.divxdede.swing.busy.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.divxdede.swing.RemainingTimeMonitor;
import org.divxdede.swing.busy.BusyIcon;
import org.divxdede.swing.busy.BusyModel;
import org.divxdede.swing.busy.icon.InfiniteBusyIcon;
import org.divxdede.swing.busy.ui.AbstractBusyLayerUI;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.BusyPainter;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.painter.Painter;

public class BasicBusyLayerUI
extends AbstractBusyLayerUI {
    JXPanel jXGlassPane = new JXPanel();
    JLabel jLabel = new JLabel();
    JProgressBar jProgressBar = new JProgressBar();
    JXHyperlink jXHyperlinkCancel = new JXHyperlink();
    BusyIcon busyIcon = null;
    Observer observer = new AnimationObserver();
    boolean remainingTimeVisible = false;
    RemainingTimeMonitor monitor = null;
    long monitorStartTime = 0L;
    int millisToDecideToPopup = 300;
    int millisToPopup = 1200;
    ActionListener cancelListener = null;
    float veilAlpha = 0.0f;
    Color veilColor = null;
    long backgroundVeilStartTime = 0L;
    int shadeDelayTotal = 0;
    private int alpha = 0;
    private Timer timer = null;
    private Painter painter = null;
    private AtomicBoolean repainted = new AtomicBoolean(false);
    private static final Border NO_SPACE = new EmptyBorder(new Insets(0, 0, 0, 0));
    private static final Border MARGIN = new EmptyBorder(new Insets(0, 10, 0, 0));
    private static final int REFRESH_DELAI = 32;

    public BasicBusyLayerUI() {
        this(400, 0.85f, Color.WHITE);
    }

    public BasicBusyLayerUI(int n, float f, Color color) {
        this.cancelListener = this.createCancelListener();
        this.timer = this.createTimer();
        this.createGlassPane();
        this.shadeDelayTotal = n;
        this.veilAlpha = f;
        this.veilColor = color;
        this.setBusyIcon(new InfiniteBusyIcon());
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        JXLayer jXLayer = (JXLayer)jComponent;
        jXLayer.setGlassPane((JPanel)this.jXGlassPane);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        JXLayer jXLayer = (JXLayer)jComponent;
        jXLayer.setGlassPane(null);
    }

    @Override
    public void setBusyIcon(BusyIcon busyIcon) {
        if (this.busyIcon != null && this.busyIcon instanceof Observable) {
            ((Observable)((Object)this.busyIcon)).deleteObserver(this.observer);
        }
        if (this.busyIcon != null) {
            this.busyIcon.setModel(null);
        }
        this.busyIcon = busyIcon;
        if (this.busyIcon != null && this.busyIcon instanceof Observable) {
            ((Observable)((Object)this.busyIcon)).addObserver(this.observer);
        }
        if (this.busyIcon != null) {
            this.busyIcon.setModel(this.getBusyModel());
        }
        this.jLabel.setIcon(this.busyIcon);
        this.updateUI();
    }

    @Override
    public BusyIcon getBusyIcon() {
        return this.busyIcon;
    }

    public void setMillisToDecideToPopup(int n) {
        this.millisToDecideToPopup = n;
    }

    public int getMillisToDecideToPopup() {
        return this.millisToDecideToPopup;
    }

    public void setMillisToPopup(int n) {
        this.millisToPopup = n;
    }

    public int getMillisToPopup() {
        return this.millisToPopup;
    }

    public void setRemainingTimeVisible(boolean bl) {
        this.remainingTimeVisible = bl;
    }

    public boolean isRemainingTimeVisible() {
        return this.remainingTimeVisible;
    }

    public BusyPainter getBusyPainter() {
        BusyIcon busyIcon = this.getBusyIcon();
        if (busyIcon instanceof InfiniteBusyIcon) {
            return ((InfiniteBusyIcon)busyIcon).getBusyPainter();
        }
        return null;
    }

    public void setBusyPainter(BusyPainter busyPainter) {
        this.setBusyPainter(busyPainter, null);
    }

    public void setBusyPainter(BusyPainter busyPainter, Dimension dimension) {
        this.setBusyIcon(new InfiniteBusyIcon(busyPainter, dimension));
    }

    protected void paintLayer(Graphics2D graphics2D, JXLayer<? extends JComponent> jXLayer) {
        super.paintLayer(graphics2D, jXLayer);
        Painter painter = this.getBackGroundPainter();
        if (painter != null) {
            painter.paint(graphics2D, null, jXLayer.getWidth(), jXLayer.getHeight());
        }
    }

    @Override
    protected void updateUIImpl() {
        boolean bl;
        BusyModel busyModel = this.getBusyModel();
        BusyIcon busyIcon = this.getBusyIcon();
        boolean bl2 = this.isComponentBusy();
        if (busyModel != null && busyModel.isBusy() && !this.timer.isRunning()) {
            this.timer.start();
        }
        this.repainted.set(true);
        this.jXGlassPane.setVisible(bl2);
        this.jLabel.setVisible(bl2);
        this.jProgressBar.setVisible(bl2 && busyModel.isDeterminate() && !busyIcon.isDeterminate());
        boolean bl3 = bl = bl2 && busyModel.isCancellable();
        if (bl && !this.jXHyperlinkCancel.isVisible()) {
            this.jXHyperlinkCancel.setClicked(false);
        }
        this.jXHyperlinkCancel.setVisible(bl);
        this.manageBackgroundVeil(bl2);
        if (bl2) {
            if (busyModel.isCancellable()) {
                this.jXHyperlinkCancel.setBorder(this.jProgressBar.isVisible() ? MARGIN : NO_SPACE);
            }
            String string = busyModel.getDescription();
            String string2 = this.getRemainingTimeString();
            if (this.isRemainingTimeVisible()) {
                if (string2 == null) {
                    string2 = " ";
                }
                if (string == null) {
                    this.jLabel.setText(string2);
                    this.jProgressBar.setString(null);
                    this.jProgressBar.setStringPainted(true);
                } else {
                    this.jLabel.setText(string);
                    this.jProgressBar.setString(string2);
                    this.jProgressBar.setStringPainted(true);
                }
            } else if (string == null) {
                this.jLabel.setText(this.getPercentProgressionString());
                this.jProgressBar.setStringPainted(false);
                this.jProgressBar.setString(null);
            } else {
                this.jLabel.setText(string);
                this.jProgressBar.setString(this.getPercentProgressionString());
                this.jProgressBar.setStringPainted(true);
            }
        }
        super.updateUIImpl();
    }

    @Override
    public void setBusyModel(BusyModel busyModel) {
        super.setBusyModel(busyModel);
        if (this.getBusyModel() != null) {
            this.jProgressBar.setModel(busyModel);
            if (this.busyIcon != null) {
                this.busyIcon.setModel(this.getBusyModel());
            }
        }
    }

    private JComponent createGlassPane() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.jXGlassPane.setLayout((LayoutManager)gridBagLayout);
        this.jXGlassPane.setOpaque(false);
        Insets insets = new Insets(0, 0, 0, 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 0, insets, 0, 0);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0);
        this.jXGlassPane.add((Component)this.jLabel, (Object)gridBagConstraints);
        this.jXGlassPane.add((Component)this.jProgressBar, (Object)gridBagConstraints2);
        this.jXGlassPane.add((Component)this.jXHyperlinkCancel, (Object)gridBagConstraints3);
        this.jLabel.setHorizontalAlignment(0);
        this.jLabel.setHorizontalTextPosition(0);
        this.jLabel.setVerticalTextPosition(3);
        this.jXHyperlinkCancel.setText(UIManager.getString("OptionPane.cancelButtonText"));
        this.jXHyperlinkCancel.addActionListener(this.cancelListener);
        this.updateUI();
        return this.jXGlassPane;
    }

    private String getPercentProgressionString() {
        BusyModel busyModel = this.getBusyModel();
        boolean bl = this.isModelBusy();
        if (!bl) {
            return null;
        }
        if (!busyModel.isDeterminate()) {
            return null;
        }
        int n = busyModel.getMaximum() - busyModel.getMinimum();
        int n2 = busyModel.getValue();
        float f = 100.0f / (float)n * (float)(n2 - busyModel.getMinimum());
        return Integer.toString((int)f) + " %";
    }

    private String getRemainingTimeString() {
        return null;
    }

    private ActionListener createCancelListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    BasicBusyLayerUI.this.getBusyModel().cancel();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
    }

    protected boolean isComponentBusy() {
        boolean bl;
        boolean bl2 = this.isModelBusy();
        boolean bl3 = bl2 && this.getBusyModel().isDeterminate();
        boolean bl4 = bl = this.getMillisToDecideToPopup() > 0 && this.getMillisToPopup() > 0;
        if (bl2 && bl3) {
            if (this.monitor == null && (bl || this.isRemainingTimeVisible())) {
                this.monitor = new RemainingTimeMonitor(this.getBusyModel());
                this.monitorStartTime = System.currentTimeMillis();
            }
            if (this.jXGlassPane.isVisible()) {
                return true;
            }
            if (bl) {
                long l = System.currentTimeMillis();
                if (l - this.monitorStartTime >= (long)this.getMillisToDecideToPopup()) {
                    long l2 = this.monitor.getRemainingTime();
                    return l2 < 0L || l2 > (long)this.getMillisToPopup();
                }
                return false;
            }
        } else if (this.monitor != null) {
            this.monitor.dispose();
            this.monitor = null;
            this.monitorStartTime = 0L;
        }
        return bl2;
    }

    @Override
    protected boolean shouldLock() {
        return this.isModelBusy() || this.isBackgroundPainterDirty(this.isComponentBusy());
    }

    private synchronized Painter getBackGroundPainter() {
        return this.painter;
    }

    protected Painter createBackgroundPainter(int n) {
        return new MattePainter((Paint)new Color(this.veilColor.getRed(), this.veilColor.getGreen(), this.veilColor.getBlue(), n));
    }

    private synchronized void manageBackgroundVeil(boolean bl) {
        if (!this.isBackgroundPainterDirty(bl)) {
            return;
        }
        if (this.shadeDelayTotal <= 0) {
            this.updateBackgroundPainter(bl);
        }
    }

    private synchronized Timer createTimer() {
        ActionListener actionListener = new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BasicBusyLayerUI basicBusyLayerUI = BasicBusyLayerUI.this;
                synchronized (basicBusyLayerUI) {
                    boolean bl = BasicBusyLayerUI.this.isComponentBusy();
                    if (BasicBusyLayerUI.this.updateBackgroundPainter(bl)) {
                        BasicBusyLayerUI.this.updateUI();
                    } else if (!BasicBusyLayerUI.this.repainted.get()) {
                        BasicBusyLayerUI.this.updateUI();
                        BasicBusyLayerUI.this.repainted.set(false);
                    }
                    if (!BasicBusyLayerUI.this.isModelBusy() && !BasicBusyLayerUI.this.isBackgroundPainterDirty(bl)) {
                        ((Timer)actionEvent.getSource()).stop();
                    }
                }
            }
        };
        return new Timer(32, actionListener);
    }

    private synchronized boolean isBackgroundPainterDirty(boolean bl) {
        if (this.veilColor == null || this.veilAlpha == 0.0f) {
            return false;
        }
        if (bl && this.alpha < 255) {
            return true;
        }
        return !bl && this.alpha > 0;
    }

    private synchronized boolean updateBackgroundPainter(boolean bl) {
        Painter painter = this.painter;
        if (bl && (this.alpha < 255 || this.painter == null)) {
            if (this.backgroundVeilStartTime <= 0L) {
                this.backgroundVeilStartTime = System.currentTimeMillis();
            }
            long l = System.currentTimeMillis() - this.backgroundVeilStartTime;
            double d = (double)l / (double)this.shadeDelayTotal;
            if (this.shadeDelayTotal <= 0) {
                this.alpha = 255;
                this.backgroundVeilStartTime = 0L;
            } else {
                this.alpha = (int)(255.0 * d);
                if (this.alpha >= 255) {
                    this.alpha = 255;
                    this.backgroundVeilStartTime = 0L;
                }
            }
            this.painter = this.createBackgroundPainter((int)((float)this.alpha * this.veilAlpha));
        } else if (!(bl || this.alpha <= 0 && this.painter == null)) {
            if (this.backgroundVeilStartTime >= 0L) {
                this.backgroundVeilStartTime = -System.currentTimeMillis();
            }
            long l = System.currentTimeMillis() + this.backgroundVeilStartTime;
            double d = (double)l / (double)this.shadeDelayTotal;
            if (this.shadeDelayTotal <= 0) {
                this.alpha = 0;
                this.backgroundVeilStartTime = 0L;
            } else {
                this.alpha = 255 - (int)(255.0 * d);
            }
            if (this.alpha > 0) {
                this.painter = this.createBackgroundPainter((int)((float)this.alpha * this.veilAlpha));
            } else {
                this.alpha = 0;
                this.painter = null;
                this.backgroundVeilStartTime = 0L;
            }
        } else {
            this.backgroundVeilStartTime = 0L;
        }
        return painter != this.painter;
    }

    private class AnimationObserver
    implements Observer {
        private AnimationObserver() {
        }

        @Override
        public void update(Observable observable, Object object) {
            BasicBusyLayerUI.this.updateUI();
        }
    }
}

