/*
 * Decompiled with CFR 0.152.
 */
package org.divxdede.swing.busy.ui;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.divxdede.swing.busy.BusyModel;
import org.divxdede.swing.busy.ui.BusyLayerUI;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.ext.LockableUI;

public abstract class AbstractBusyLayerUI
extends LockableUI
implements BusyLayerUI {
    private BusyModel model = null;
    private ChangeListener modelListener = null;
    private AtomicBoolean lastBusyState = new AtomicBoolean(false);

    public AbstractBusyLayerUI() {
        this.modelListener = this.createModelListener();
    }

    @Override
    public void setBusyModel(BusyModel busyModel) {
        BusyModel busyModel2 = this.getBusyModel();
        if (this.getBusyModel() != null) {
            this.getBusyModel().removeChangeListener(this.modelListener);
        }
        this.model = busyModel;
        if (this.getBusyModel() != null) {
            this.lastBusyState.set(this.model.isBusy());
            this.getBusyModel().addChangeListener(this.modelListener);
            this.updateUI();
        }
    }

    @Override
    public BusyModel getBusyModel() {
        return this.model;
    }

    protected final void updateUI() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateUIImpl();
        } else {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AbstractBusyLayerUI.this.updateUIImpl();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void updateUI(JXLayer<? extends JComponent> jXLayer) {
        this.updateUI();
        super.updateUI(jXLayer);
    }

    protected void updateUIImpl() {
        this.setLocked(this.shouldLock());
        this.setDirty(true);
    }

    protected boolean isModelBusy() {
        return this.getBusyModel() == null ? false : this.getBusyModel().isBusy();
    }

    protected boolean shouldLock() {
        return this.isModelBusy();
    }

    private ChangeListener createModelListener() {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = AbstractBusyLayerUI.this.getBusyModel().isBusy();
                if (AbstractBusyLayerUI.this.lastBusyState.get() != bl) {
                    AbstractBusyLayerUI.this.lastBusyState.set(bl);
                    AbstractBusyLayerUI.this.updateUI();
                }
            }
        };
    }
}

