/*
 * Decompiled with CFR 0.152.
 */
package org.divxdede.swing.busy.icon;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import javax.swing.Icon;
import org.divxdede.swing.busy.icon.ColorUtilities;
import org.divxdede.swing.busy.icon.DecoratorBusyIcon;

public class RadialBusyIcon
extends DecoratorBusyIcon {
    private static final int DETERMINATE_ARC_LENGTH = 45;
    private static final int DETERMINATE_RADIAL_INSETS = 4;
    private static final int UNDETERMINATE_ADVANCE_LENGTH = 60;
    private static final int UNDETERMINATE_ARC_LENGTH = 360;
    private static final int UNDETERMINATE_RADIAL_INSETS = 0;
    private Paint barBackground = null;
    private Paint barForeground = null;
    private int diameter = 0;
    private int thickness = 0;
    private int delay = 1000;

    public RadialBusyIcon(Icon icon) {
        this(icon, new Insets(7, 7, 7, 7));
    }

    public RadialBusyIcon(Icon icon, Insets insets) {
        super(icon, insets);
        this.setDelay(1500);
        this.installDefaults();
    }

    @Override
    protected final void paintUndeterminate(Component component, Graphics graphics, int n, int n2, int n3) {
        float f = (float)n3 / 36.0f;
        float f2 = f + 0.16666667f;
        this.paintImpl(component, graphics, n, n2, false, f, f2);
    }

    @Override
    protected final void paintDeterminate(Component component, Graphics graphics, int n, int n2, float f) {
        this.paintImpl(component, graphics, n, n2, true, 0.0f, f);
    }

    protected void paintProgressBar(Component component, Graphics graphics, boolean bl) {
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = 45;
        int n3 = 4;
        if (!bl) {
            n2 = 360;
            n3 = 0;
        }
        int n4 = (this.getIconWidth() - this.getProgressBarDiameter()) / 2;
        int n5 = (this.getIconHeight() - this.getProgressBarDiameter()) / 2;
        graphics2D.setPaint(this.getProgressBarBackground());
        for (n = n3; n < 360; n += n2) {
            int n6 = n;
            int n7 = n2 - n3 * 2;
            graphics2D.fillArc(n4, n5, this.getProgressBarDiameter(), this.getProgressBarDiameter(), RadialBusyIcon.translateAngle(n6), n7 * -1);
        }
        graphics2D.setComposite(AlphaComposite.Clear);
        n = this.getProgressBarDiameter() - this.getProgressBarThickness();
        n4 = (this.getIconWidth() - n) / 2;
        n5 = (this.getIconHeight() - n) / 2;
        graphics2D.fillOval(n4, n5, n, n);
        graphics2D.setPaintMode();
    }

    protected void paintProgressBarAdvance(Component component, Graphics graphics, boolean bl, float f, float f2) {
        int n;
        int n2 = 45;
        int n3 = 4;
        if (!bl) {
            n2 = 360;
            n3 = 0;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setPaint(this.getProgressBarForeground());
        int n4 = (this.getIconWidth() - this.getProgressBarDiameter()) / 2;
        int n5 = (this.getIconHeight() - this.getProgressBarDiameter()) / 2;
        int n6 = Math.round(f * 360.0f);
        int n7 = Math.round(f2 * 360.0f);
        boolean bl2 = false;
        for (n = n3; n < 360 + n2; n += n2) {
            int n8 = n2 - n3 * 2;
            int n9 = n;
            int n10 = n9 + n8;
            if (!bl2) {
                if (n - n3 > n6 || n6 >= n10) continue;
                bl2 = true;
            }
            if (n7 < n9) break;
            n9 = Math.max(n6, n9);
            n10 = Math.min(n7, n10);
            graphics2D.fillArc(n4, n5, this.getProgressBarDiameter(), this.getProgressBarDiameter(), RadialBusyIcon.translateAngle(n9), (n10 - n9) * -1);
        }
        graphics2D.setComposite(AlphaComposite.Clear);
        n = this.getProgressBarDiameter() - this.getProgressBarThickness();
        n4 = (this.getIconWidth() - n) / 2;
        n5 = (this.getIconHeight() - n) / 2;
        graphics2D.fillOval(n4, n5, n, n);
        graphics2D.setPaintMode();
    }

    @Override
    protected float getSignificantRatioOffset() {
        return 0.0027777778f;
    }

    public void setDelay(int n) {
        this.setUndeterminateFrameRate(Math.round((float)n / 36.0f), 36);
        this.delay = n;
    }

    public int getDelay() {
        return this.delay;
    }

    protected void setProgressBarDiameter(int n) {
        int n2 = this.getProgressBarDiameter();
        this.diameter = n;
        if (n2 != this.getProgressBarDiameter()) {
            this.repaint(true);
        }
    }

    protected int getProgressBarDiameter() {
        return this.diameter;
    }

    protected void setProgressBarThickness(int n) {
        int n2 = this.getProgressBarThickness();
        this.thickness = n;
        if (n2 != this.getProgressBarThickness()) {
            this.repaint(true);
        }
    }

    protected int getProgressBarThickness() {
        return this.thickness;
    }

    public void setProgressBarBackground(Paint paint) {
        Paint paint2 = this.barBackground;
        this.barBackground = paint;
        if (paint2 != this.barBackground) {
            this.repaint(true);
        }
    }

    public Paint getProgressBarBackground() {
        return this.barBackground;
    }

    public void setProgressBarForeground(Paint paint) {
        Paint paint2 = this.barForeground;
        this.barForeground = paint;
        if (paint2 != this.barForeground) {
            this.repaint(true);
        }
    }

    public Paint getProgressBarForeground() {
        return this.barForeground;
    }

    protected void installDefaults() {
        int n = Math.min(this.getIconWidth(), this.getIconHeight());
        int n2 = Math.round((float)n * 0.5f);
        this.setProgressBarDiameter(n);
        this.setProgressBarThickness(n2);
        this.setProgressBarBackground(this.createPaintUI(Color.GRAY, true));
        this.setProgressBarForeground(this.createPaintUI(new Color(117, 205, 78), true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintImpl(Component component, Graphics graphics, int n, int n2, boolean bl, float f, float f2) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            graphics2D.translate(n, n2);
            this.paintProgressBar(component, graphics, bl);
        }
        finally {
            graphics2D.dispose();
        }
        graphics2D = (Graphics2D)graphics.create();
        try {
            graphics2D.translate(n, n2);
            this.paintProgressBarAdvance(component, graphics, bl, f, f2);
        }
        finally {
            graphics2D.dispose();
        }
        graphics2D = (Graphics2D)graphics.create();
        try {
            this.paintDecoratedIcon(component, graphics, n, n2);
        }
        finally {
            graphics2D.dispose();
        }
    }

    private static int translateAngle(int n) {
        return (n - 90) * -1;
    }

    private Paint createPaintUI(Color color, boolean bl) {
        if (bl) {
            int n = this.getProgressBarDiameter();
            int n2 = this.getProgressBarDiameter() - this.getProgressBarThickness();
            float f = (float)n2 / (float)n;
            int n3 = (this.getIconWidth() - n) / 2 + n / 2;
            int n4 = (this.getIconHeight() - n) / 2 + n / 2;
            Color color2 = ColorUtilities.brighter(color, 0.4f);
            Color color3 = color;
            return new RadialGradientPaint(n3, (float)n4, Math.round((float)n / 2.0f), new float[]{f, 1.0f}, new Color[]{color2, color3});
        }
        return color;
    }
}

