/*
 * Decompiled with CFR 0.152.
 */
package org.divxdede.swing.busy.icon;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.UIManager;
import org.divxdede.swing.busy.icon.AbstractBusyIcon;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.painter.BusyPainter;

public class InfiniteBusyIcon
extends AbstractBusyIcon {
    private BusyPainter painter = null;
    private int frame = 0;
    private Dimension dimension = null;
    private int delay = -1;

    public InfiniteBusyIcon() {
        this(null, null);
    }

    public InfiniteBusyIcon(Dimension dimension) {
        this(null, dimension);
    }

    public InfiniteBusyIcon(BusyPainter busyPainter, Dimension dimension) {
        if (busyPainter == null) {
            busyPainter = new BusyPainter();
        }
        if (dimension == null) {
            dimension = new Dimension(26, 26);
        }
        this.dimension = dimension;
        this.setBusyPainter(busyPainter);
    }

    @Override
    protected void paintIdle(Component component, Graphics graphics, int n, int n2) {
        this.paintBackground(component, graphics, n, n2);
    }

    @Override
    protected void paintDeterminate(Component component, Graphics graphics, int n, int n2, float f) {
        this.paintIdle(component, graphics, n, n2);
    }

    @Override
    protected void paintUndeterminate(Component component, Graphics graphics, int n, int n2, int n3) {
        this.paintBackground(component, graphics, n, n2);
        if (this.getBusyPainter() != null) {
            this.getBusyPainter().setFrame(n3);
        }
        this.paintInfiniteSpinner(component, graphics, n, n2);
    }

    protected void paintBackground(Component component, Graphics graphics, int n, int n2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintInfiniteSpinner(Component component, Graphics graphics, int n, int n2) {
        BusyPainter busyPainter = this.getBusyPainter();
        if (busyPainter != null) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            try {
                graphics2D.translate(n, n2);
                busyPainter.paint(graphics2D, null, this.getIconWidth(), this.getIconHeight());
            }
            finally {
                graphics2D.dispose();
            }
        }
    }

    @Override
    public boolean isDeterminate() {
        return false;
    }

    public void setDelay(int n) {
        BusyPainter busyPainter = this.getBusyPainter();
        this.delay = n;
        if (busyPainter != null) {
            this.setUndeterminateFrameRate(this.getDelay(), busyPainter.getPoints());
        } else {
            this.setUndeterminateFrameRate(0, 0);
        }
    }

    public int getDelay() {
        if (this.delay == -1) {
            return UIManager.getInt("JXBusyLabel.delay");
        }
        return this.delay;
    }

    public void setBusyPainter(BusyPainter busyPainter) {
        this.painter = busyPainter;
        this.frame = 0;
        if (this.painter != null) {
            this.setUndeterminateFrameRate(this.getDelay(), busyPainter.getPoints());
        } else {
            this.setUndeterminateFrameRate(0, 0);
        }
        this.repaint(true);
    }

    public BusyPainter getBusyPainter() {
        return this.painter;
    }

    @Override
    public int getIconWidth() {
        return (int)this.dimension.getWidth();
    }

    @Override
    public int getIconHeight() {
        return (int)this.dimension.getHeight();
    }

    @Override
    protected float getSignificantRatioOffset() {
        return 0.01f;
    }

    static {
        new JXBusyLabel();
    }
}

