/*
 * Decompiled with CFR 0.152.
 */
package org.divxdede.swing.busy.icon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.divxdede.swing.busy.icon.ColorUtilities;
import org.divxdede.swing.busy.icon.DecoratorBusyIcon;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.painter.RectanglePainter;

public class DefaultBusyIcon
extends DecoratorBusyIcon {
    private static final int FRAMES = 20;
    private static final float FRAME_STEP_RATIO = 0.05f;
    private static final int FRAME_EXTENDS = Math.round(6.6000004f);
    private boolean backgroundPainted = true;
    private Painter backgroundPainter = null;
    private Paint barBackground = null;
    private Paint barForeground = null;
    private Rectangle barBounds = new Rectangle(0, 0, 10, 10);
    private int delay = 1000;

    public DefaultBusyIcon(Icon icon) {
        this(icon, (Insets)null);
    }

    public DefaultBusyIcon(Icon icon, Insets insets) {
        this(icon, (Painter)null, insets);
    }

    public DefaultBusyIcon(Icon icon, Color color) {
        this(icon, (Painter)null, null);
    }

    public DefaultBusyIcon(Icon icon, Color color, Insets insets) {
        this(icon, (Painter)null, insets);
        if (color != null) {
            this.installDefaultBackgroundPainter(color);
        }
    }

    public DefaultBusyIcon(Icon icon, Painter painter) {
        this(icon, painter, null);
    }

    public DefaultBusyIcon(Icon icon, Painter painter, Insets insets) {
        super(icon, insets == null ? new Insets(4, 4, 4, 4) : insets);
        this.setDelay(500);
        this.installDefaultProgressBarBounds();
        if (painter != null) {
            this.setBackgroundPainter(painter);
        } else {
            this.installDefaultBackgroundPainter(Color.BLACK);
        }
        this.installDefaultProgressBarColors();
    }

    @Override
    protected final void paintUndeterminate(Component component, Graphics graphics, int n, int n2, int n3) {
        int n4 = 20 - FRAME_EXTENDS;
        int n5 = n4 * 2;
        if (n3 >= n4) {
            n3 = Math.abs(n3 - n5);
        }
        float f = (float)n3 * 0.05f;
        float f2 = f + (float)FRAME_EXTENDS * 0.05f;
        this.paintImpl(component, graphics, n, n2, false, f, f2);
    }

    @Override
    protected final void paintDeterminate(Component component, Graphics graphics, int n, int n2, float f) {
        this.paintImpl(component, graphics, n, n2, true, 0.0f, f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void paintIdle(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D;
        if (this.isBackgroundPainted()) {
            graphics2D = (Graphics2D)graphics.create();
            try {
                graphics2D.translate(n, n2);
                this.paintBackground(component, graphics2D);
            }
            finally {
                graphics2D.dispose();
            }
        }
        graphics2D = (Graphics2D)graphics.create();
        try {
            this.paintDecoratedIcon(component, graphics2D, n, n2);
        }
        finally {
            graphics2D.dispose();
        }
    }

    public void setDelay(int n) {
        float f = 20 - FRAME_EXTENDS + 1;
        this.setUndeterminateFrameRate(Math.round((float)n / f), (20 - FRAME_EXTENDS) * 2);
        this.delay = n;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setBackgroundColor(Color color) {
        this.installDefaultBackgroundPainter(color);
    }

    public void setBackgroundPainter(Painter painter) {
        Painter painter2 = this.getBackgroundPainter();
        this.backgroundPainter = painter;
        if (painter2 != this.getBackgroundPainter()) {
            this.repaint(true);
        }
    }

    public Painter getBackgroundPainter() {
        return this.backgroundPainter;
    }

    public void setBackgroundPainted(boolean bl) {
        boolean bl2 = this.isBackgroundPainted();
        this.backgroundPainted = bl;
        if (bl2 != this.isBackgroundPainted()) {
            this.repaint(true);
        }
    }

    public boolean isBackgroundPainted() {
        return this.backgroundPainted;
    }

    protected Rectangle getProgressBarBounds() {
        return this.barBounds;
    }

    protected void setProgressBarBounds(Rectangle rectangle) {
        this.barBounds = rectangle;
    }

    public void setProgressBarBackground(Paint paint) {
        Paint paint2 = this.barBackground;
        this.barBackground = paint;
        if (paint2 != this.barBackground) {
            this.repaint(true);
        }
    }

    public Paint getProgressBarBackground() {
        return this.barBackground;
    }

    public void setProgressBarForeground(Paint paint) {
        Paint paint2 = this.barForeground;
        this.barForeground = paint;
        if (paint2 != this.barForeground) {
            this.repaint(true);
        }
    }

    public Paint getProgressBarForeground() {
        return this.barForeground;
    }

    protected void installDefaultBackgroundPainter(Color color) {
        Color color2 = ColorUtilities.brighter(color, 0.6f);
        Color color3 = color;
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(0.0f, 0.0f, 0.0f, this.getIconHeight(), new float[]{0.2f, 0.8f}, new Color[]{color2, color3});
        RectanglePainter rectanglePainter = new RectanglePainter(new Insets(0, 0, 0, 0), this.getIconWidth(), this.getIconHeight(), this.getIconWidth() / 4, this.getIconHeight() / 4, true, (Paint)linearGradientPaint, 1.0f, (Paint)color3);
        this.setBackgroundPainter((Painter)rectanglePainter);
    }

    protected void installDefaultProgressBarColors() {
        this.setProgressBarBackground(this.createPaintUI("ProgressBar.background", this.getProgressBarBounds(), true));
        this.setProgressBarForeground(this.createPaintUI("ProgressBar.foreground", this.getProgressBarBounds(), true));
    }

    protected void installDefaultProgressBarBounds() {
        int n = (int)((float)this.getIconHeight() * 0.12f);
        int n2 = (int)((float)this.getIconWidth() * 0.8f);
        int n3 = (this.getIconWidth() - n2) / 2;
        int n4 = (int)((float)this.getIconHeight() * 0.75f);
        this.setProgressBarBounds(new Rectangle(n3, n4, n2, n));
    }

    protected void paintBackground(Component component, Graphics graphics) {
        Painter painter = this.getBackgroundPainter();
        if (painter != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            painter.paint(graphics2D, null, this.getIconWidth(), this.getIconHeight());
        }
    }

    protected void paintProgressBar(Component component, Graphics graphics, Rectangle rectangle, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setPaint(this.barBackground);
        graphics2D.fillRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.height, rectangle.height / 2);
    }

    protected void paintProgressBarAdvance(Component component, Graphics graphics, Rectangle rectangle, boolean bl, float f, float f2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n = Math.round((float)rectangle.width * f);
        int n2 = Math.round((float)rectangle.width * (f2 - f));
        if (n < 0) {
            n = 0;
        }
        if (n + n2 > rectangle.x + rectangle.width) {
            n2 = rectangle.x + rectangle.width - n;
        }
        graphics2D.setPaint(this.barForeground);
        graphics2D.fillRoundRect(rectangle.x + n, rectangle.y, n2, rectangle.height, rectangle.height, rectangle.height / 2);
    }

    @Override
    protected float getSignificantRatioOffset() {
        if (this.getDecoratedIcon() == null) {
            return 0.1f;
        }
        return 1.0f / (float)this.getProgressBarBounds().width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintImpl(Component component, Graphics graphics, int n, int n2, boolean bl, float f, float f2) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            this.paintIdle(component, graphics, n, n2);
        }
        finally {
            graphics2D.dispose();
        }
        graphics2D = (Graphics2D)graphics.create();
        try {
            graphics2D.translate(n, n2);
            graphics2D.setClip(this.getProgressBarBounds());
            this.paintProgressBar(component, graphics, this.getProgressBarBounds(), bl);
        }
        finally {
            graphics2D.dispose();
        }
        graphics2D = (Graphics2D)graphics.create();
        try {
            graphics2D.translate(n, n2);
            graphics2D.setClip(this.getProgressBarBounds());
            this.paintProgressBarAdvance(component, graphics, this.getProgressBarBounds(), bl, f, f2);
        }
        finally {
            graphics2D.dispose();
        }
    }

    private Paint createPaintUI(String string, Rectangle rectangle, boolean bl) {
        Color color = UIManager.getColor(string);
        if (bl) {
            return new LinearGradientPaint(0.0f, rectangle.y, 0.0f, rectangle.y + rectangle.height, new float[]{0.5f, 1.0f}, new Color[]{ColorUtilities.brighter(color, 0.3f), color});
        }
        return color;
    }
}

