/*
 * Decompiled with CFR 0.152.
 */
package org.divxdede.swing.busy.icon;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.divxdede.swing.busy.icon.AbstractBusyIcon;

public abstract class DecoratorBusyIcon
extends AbstractBusyIcon {
    private Icon icon = null;
    private BufferedImage iconFrame = null;
    private FrameObserver frameObserver = new FrameObserver();
    private Insets insets = null;

    public DecoratorBusyIcon(Icon icon) {
        this(icon, null);
    }

    public DecoratorBusyIcon(Icon icon, Insets insets) {
        this.setDecoratedIcon(icon);
        this.setInsets(insets);
    }

    public Icon getDecoratedIcon() {
        return this.icon;
    }

    public synchronized void setDecoratedIcon(Icon icon) {
        if (this.icon == icon) {
            return;
        }
        if (this.icon instanceof ImageIcon) {
            ((ImageIcon)this.icon).setImageObserver(null);
        }
        if (this.icon instanceof Observable) {
            ((Observable)((Object)this.icon)).deleteObserver(this.frameObserver);
        }
        this.icon = icon;
        this.iconFrame = null;
        if (this.icon != null) {
            GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            this.iconFrame = graphicsConfiguration.createCompatibleImage(this.icon.getIconWidth(), this.icon.getIconHeight(), 3);
            if (this.icon instanceof ImageIcon) {
                ((ImageIcon)this.icon).setImageObserver(this.frameObserver);
            }
            if (this.icon instanceof Observable) {
                ((Observable)((Object)this.icon)).addObserver(this.frameObserver);
            }
        }
        this.doIconFrameUpdate(null);
    }

    protected Insets getInsets() {
        return this.insets;
    }

    protected void setInsets(Insets insets) {
        this.insets = insets;
        this.repaint(true);
    }

    @Override
    protected void paintIdle(Component component, Graphics graphics, int n, int n2) {
        this.paintDecoratedIcon(component, graphics, n, n2);
    }

    protected synchronized void paintDecoratedIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.iconFrame != null) {
            Insets insets = this.getInsets();
            if (insets != null) {
                n = insets.left;
                n2 = insets.top;
            }
            graphics.drawImage(this.iconFrame, n, n2, null);
        }
    }

    @Override
    public int getIconWidth() {
        int n;
        Icon icon = this.getDecoratedIcon();
        Insets insets = this.getInsets();
        int n2 = n = icon == null ? 0 : icon.getIconWidth();
        if (insets != null) {
            n += insets.left + insets.right;
        }
        return n;
    }

    @Override
    public int getIconHeight() {
        int n;
        Icon icon = this.getDecoratedIcon();
        Insets insets = this.getInsets();
        int n2 = n = icon == null ? 0 : icon.getIconHeight();
        if (insets != null) {
            n += insets.top + insets.bottom;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doIconFrameUpdate(Image image) {
        if (this.iconFrame != null) {
            Graphics2D graphics2D = this.iconFrame.createGraphics();
            try {
                graphics2D.setComposite(AlphaComposite.Clear);
                graphics2D.fillRect(0, 0, this.icon.getIconWidth(), this.icon.getIconHeight());
                graphics2D.setPaintMode();
                if (image != null) {
                    graphics2D.drawImage(image, 0, 0, null);
                } else {
                    this.icon.paintIcon(null, graphics2D, 0, 0);
                }
            }
            finally {
                graphics2D.dispose();
            }
        }
        this.repaint(true);
    }

    private class FrameObserver
    implements ImageObserver,
    Observer {
        private FrameObserver() {
        }

        @Override
        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            if ((n & 0x30) != 0) {
                DecoratorBusyIcon.this.doIconFrameUpdate(image);
            }
            return (n & 0xA0) == 0;
        }

        @Override
        public void update(Observable observable, Object object) {
            DecoratorBusyIcon.this.doIconFrameUpdate(null);
        }
    }
}

