/*
 * Decompiled with CFR 0.152.
 */
package org.divxdede.swing.busy.icon;

import java.awt.Color;

public class ColorUtilities {
    private ColorUtilities() {
    }

    public static Color brighter(Color color) {
        return ColorUtilities.brighter(color, 0.251f);
    }

    public static Color brighter(Color color, float f) {
        if (f == 0.0f) {
            return color;
        }
        if (f >= 1.0f) {
            return new Color(255, 255, 255, color.getAlpha());
        }
        float[] fArray = ColorUtilities.RGBtoHSL(color.getRed(), color.getGreen(), color.getBlue());
        if (fArray[2] == 0.0f) {
            fArray[2] = f;
        } else {
            fArray[2] = fArray[2] * (1.0f + f);
            if (fArray[2] > 1.0f) {
                fArray[2] = 1.0f;
            }
        }
        int[] nArray = ColorUtilities.HSLtoRGB(fArray[0], fArray[1], fArray[2], null);
        return new Color(nArray[0], nArray[1], nArray[2], color.getAlpha());
    }

    public static Color darker(Color color) {
        return ColorUtilities.darker(color, 0.251f);
    }

    public static Color darker(Color color, float f) {
        if (f == 0.0f) {
            return color;
        }
        if (f >= 1.0f) {
            return new Color(0, 0, 0, color.getAlpha());
        }
        float[] fArray = ColorUtilities.RGBtoHSL(color.getRed(), color.getGreen(), color.getBlue());
        fArray[2] = fArray[2] * (1.0f - f);
        int[] nArray = ColorUtilities.HSLtoRGB(fArray[0], fArray[1], fArray[2], null);
        return new Color(nArray[0], nArray[1], nArray[2], color.getAlpha());
    }

    public static Color translucent(Color color, int n) {
        if (color.getAlpha() == n) {
            return color;
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
    }

    private static float[] RGBtoHSL(Color color) {
        return ColorUtilities.RGBtoHSL(color.getRed(), color.getGreen(), color.getBlue(), null);
    }

    private static float[] RGBtoHSL(Color color, float[] fArray) {
        return ColorUtilities.RGBtoHSL(color.getRed(), color.getGreen(), color.getBlue(), fArray);
    }

    private static float[] RGBtoHSL(int n, int n2, int n3) {
        return ColorUtilities.RGBtoHSL(n, n2, n3, null);
    }

    private static float[] RGBtoHSL(int n, int n2, int n3, float[] fArray) {
        float f;
        float f2;
        float f3;
        float f4;
        if (fArray == null) {
            fArray = new float[3];
        } else if (fArray.length < 3) {
            throw new IllegalArgumentException("hsl array must have a length of at least 3");
        }
        if (n < 0) {
            n = 0;
        } else if (n > 255) {
            n = 255;
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > 255) {
            n2 = 255;
        }
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 > 255) {
            n3 = 255;
        }
        float f5 = (float)n / 255.0f;
        float f6 = (float)n2 / 255.0f;
        float f7 = (float)n3 / 255.0f;
        if (f5 > f6) {
            f4 = f6;
            f3 = f5;
        } else {
            f4 = f5;
            f3 = f6;
        }
        if (f7 > f3) {
            f3 = f7;
        }
        if (f7 < f4) {
            f4 = f7;
        }
        float f8 = f3 - f4;
        float f9 = (f3 + f4) / 2.0f;
        if (f8 - 0.01f <= 0.0f) {
            f2 = 0.0f;
            f = 0.0f;
        } else {
            f = f9 < 0.5f ? f8 / (f3 + f4) : f8 / (2.0f - f3 - f4);
            float f10 = ((f3 - f5) / 6.0f + f8 / 2.0f) / f8;
            float f11 = ((f3 - f6) / 6.0f + f8 / 2.0f) / f8;
            float f12 = ((f3 - f7) / 6.0f + f8 / 2.0f) / f8;
            f2 = f5 == f3 ? f12 - f11 : (f6 == f3 ? 0.33333334f + f10 - f12 : 0.6666667f + f11 - f10);
            if (f2 < 0.0f) {
                f2 += 1.0f;
            }
            if (f2 > 1.0f) {
                f2 -= 1.0f;
            }
        }
        fArray[0] = f2;
        fArray[1] = f;
        fArray[2] = f9;
        return fArray;
    }

    private static Color HSLtoRGB(float f, float f2, float f3) {
        int[] nArray = ColorUtilities.HSLtoRGB(f, f2, f3, null);
        return new Color(nArray[0], nArray[1], nArray[2]);
    }

    private static int[] HSLtoRGB(float f, float f2, float f3, int[] nArray) {
        int n;
        int n2;
        int n3;
        if (nArray == null) {
            nArray = new int[3];
        } else if (nArray.length < 3) {
            throw new IllegalArgumentException("rgb array must have a length of at least 3");
        }
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        if (f3 < 0.0f) {
            f3 = 0.0f;
        } else if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        if (f2 - 0.01f <= 0.0f) {
            n3 = (int)(f3 * 255.0f);
            n2 = (int)(f3 * 255.0f);
            n = (int)(f3 * 255.0f);
        } else {
            float f4 = f3 < 0.5f ? f3 * (1.0f + f2) : f3 + f2 - f2 * f3;
            float f5 = 2.0f * f3 - f4;
            n3 = (int)(255.0f * ColorUtilities.hue2RGB(f5, f4, f + 0.33333334f));
            n2 = (int)(255.0f * ColorUtilities.hue2RGB(f5, f4, f));
            n = (int)(255.0f * ColorUtilities.hue2RGB(f5, f4, f - 0.33333334f));
        }
        nArray[0] = n3;
        nArray[1] = n2;
        nArray[2] = n;
        return nArray;
    }

    private static float hue2RGB(float f, float f2, float f3) {
        if (f3 < 0.0f) {
            f3 += 1.0f;
        }
        if (f3 > 1.0f) {
            f3 -= 1.0f;
        }
        if (6.0f * f3 < 1.0f) {
            return f + (f2 - f) * 6.0f * f3;
        }
        if (2.0f * f3 < 1.0f) {
            return f2;
        }
        if (3.0f * f3 < 2.0f) {
            return f + (f2 - f) * (0.6666667f - f3) * 6.0f;
        }
        return f;
    }
}

