/*
 * Decompiled with CFR 0.152.
 */
package org.divxdede.swing.busy.icon;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import javax.swing.BoundedRangeModel;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.divxdede.swing.busy.BusyIcon;
import org.divxdede.swing.busy.BusyModel;

public abstract class AbstractBusyIcon
extends Observable
implements BusyIcon {
    private BoundedRangeModel model = null;
    private final ModelListener modelListener = new ModelListener();
    private final List<WeakReference<Component>> components = new LinkedList<WeakReference<Component>>();
    private BufferedImage cache = null;
    private float lastRatio = -1.0f;
    private int lastStateFlag = 0;
    private boolean discarded = false;
    private boolean useCache = true;
    private int undeterminateFrameRate = 0;
    private Timer undeterminateTimer = null;
    private final ActionListener undeterminateListener = new TimerListener();
    private int frameCount = 0;
    private int frame = 0;

    public AbstractBusyIcon() {
        this.undeterminateTimer = new Timer(0, this.undeterminateListener);
    }

    protected abstract void paintDeterminate(Component var1, Graphics var2, int var3, int var4, float var5);

    protected abstract void paintUndeterminate(Component var1, Graphics var2, int var3, int var4, int var5);

    protected abstract void paintIdle(Component var1, Graphics var2, int var3, int var4);

    protected abstract float getSignificantRatioOffset();

    @Override
    public synchronized void setModel(BoundedRangeModel boundedRangeModel) {
        if (this.getModel() != null) {
            this.getModel().removeChangeListener(this.modelListener);
        }
        this.model = boundedRangeModel;
        if (this.getModel() != null) {
            this.getModel().addChangeListener(this.modelListener);
        }
    }

    @Override
    public synchronized BoundedRangeModel getModel() {
        return this.model;
    }

    @Override
    public boolean isDeterminate() {
        BusyModel busyModel = this.getBusyModel();
        if (busyModel != null) {
            return busyModel.isDeterminate();
        }
        return this.getModel() != null;
    }

    public boolean isBusy() {
        BusyModel busyModel = this.getBusyModel();
        if (busyModel != null) {
            return busyModel.isBusy();
        }
        return this.getModel() != null;
    }

    protected void setUndeterminateFrameRate(int n, int n2) {
        this.undeterminateFrameRate = n;
        this.frameCount = n2;
        this.refreshUndeterminateTimer();
    }

    @Override
    public final void paintIcon(Component component, Graphics graphics, int n, int n2) {
        BufferedImage bufferedImage;
        int n3;
        boolean bl;
        if (this.countObservers() == 0) {
            this.register(component);
        }
        boolean bl2 = (bl = this.isBusy()) && this.isDeterminate();
        float f = bl2 ? this.getRatio() : 0.0f;
        int n4 = n3 = this.frame < 0 ? 0 : this.frame;
        if (!this.isCacheUpToDate(bl, bl2, f)) {
            if (this.useCache()) {
                bufferedImage = this.getCache();
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setComposite(AlphaComposite.Clear);
                graphics2D.fillRect(0, 0, this.getIconWidth(), this.getIconHeight());
                graphics2D.setPaintMode();
                if (bl) {
                    if (bl2) {
                        this.paintDeterminate(component, graphics2D, 0, 0, f);
                    } else {
                        this.paintUndeterminate(component, graphics2D, 0, 0, n3);
                    }
                } else {
                    this.paintIdle(component, graphics2D, 0, 0);
                }
                this.lastRatio = f;
                this.lastStateFlag = this.getStateFlag(bl, bl2);
                this.discarded = false;
            } else {
                if (bl) {
                    if (bl2) {
                        this.paintDeterminate(component, graphics, n, n2, f);
                    } else {
                        this.paintUndeterminate(component, graphics, n, n2, n3);
                    }
                } else {
                    this.paintIdle(component, graphics, n, n2);
                }
                this.lastRatio = f;
                this.lastStateFlag = this.getStateFlag(bl, bl2);
                this.discarded = false;
                return;
            }
        }
        bufferedImage = this.getCache();
        graphics.drawImage(bufferedImage, n, n2, component);
    }

    public synchronized boolean useCache() {
        return this.useCache;
    }

    public void setUseCache(boolean bl) {
        boolean bl2 = this.useCache();
        this.useCache = bl;
        if (bl2 != this.useCache()) {
            this.repaint(true);
        }
    }

    protected synchronized void repaint(boolean bl) {
        if (!bl) {
            if (this.isCacheUpToDate(this.isBusy(), this.isDeterminate(), this.getRatio())) {
                return;
            }
        } else {
            this.discarded = true;
        }
        Iterator<WeakReference<Component>> iterator = this.components.iterator();
        while (iterator.hasNext()) {
            WeakReference<Component> weakReference = iterator.next();
            Component component = (Component)weakReference.get();
            if (component == null) {
                iterator.remove();
                continue;
            }
            if (component.isShowing()) {
                component.repaint();
                continue;
            }
            iterator.remove();
        }
        this.setChanged();
        this.notifyObservers();
    }

    private BusyModel getBusyModel() {
        BoundedRangeModel boundedRangeModel = this.getModel();
        if (boundedRangeModel instanceof BusyModel) {
            return (BusyModel)boundedRangeModel;
        }
        return null;
    }

    private boolean isCacheUpToDate(boolean bl, boolean bl2, float f) {
        int n = this.getStateFlag(bl, bl2);
        if (n != this.lastStateFlag) {
            return false;
        }
        if (bl2) {
            return this.useCache() && !this.discarded && this.lastRatio >= 0.0f && this.getRatioOffset(f) < this.getSignificantRatioOffset();
        }
        return this.useCache() && !this.discarded;
    }

    private synchronized BufferedImage getCache() {
        if (!this.useCache()) {
            return null;
        }
        if (this.cache == null || this.cache.getWidth() != this.getIconWidth() || this.cache.getHeight() != this.getIconHeight()) {
            GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            this.cache = graphicsConfiguration.createCompatibleImage(this.getIconWidth(), this.getIconHeight(), 3);
        }
        return this.cache;
    }

    private float getRatio() {
        BoundedRangeModel boundedRangeModel = this.getModel();
        BusyModel busyModel = this.getBusyModel();
        if (busyModel != null) {
            if (!busyModel.isBusy()) {
                return 0.0f;
            }
            if (!busyModel.isDeterminate()) {
                return 0.0f;
            }
        }
        if (boundedRangeModel != null) {
            int n = boundedRangeModel.getMaximum() - boundedRangeModel.getMinimum();
            int n2 = boundedRangeModel.getValue() + boundedRangeModel.getExtent();
            return (float)n2 / (float)n;
        }
        return 0.0f;
    }

    private float getRatioOffset(float f) {
        return Math.abs(f - this.lastRatio);
    }

    private int getStateFlag(boolean bl, boolean bl2) {
        return (bl ? 1 : 0) + (bl2 ? 2 : 0);
    }

    private synchronized void register(Component component) {
        Iterator<WeakReference<Component>> iterator = this.components.iterator();
        while (iterator.hasNext()) {
            WeakReference<Component> weakReference = iterator.next();
            Component component2 = (Component)weakReference.get();
            if (component2 == null) {
                iterator.remove();
            }
            if (component2 != component) continue;
            return;
        }
        this.components.add(new WeakReference<Component>(component));
    }

    private boolean refreshUndeterminateTimer() {
        boolean bl;
        boolean bl2 = bl = this.isBusy() && !this.isDeterminate() && this.undeterminateFrameRate > 0;
        if (bl) {
            this.undeterminateTimer.setDelay(this.undeterminateFrameRate);
            if (!this.undeterminateTimer.isRunning()) {
                this.frame = -1;
                this.undeterminateTimer.start();
                return true;
            }
        } else if (this.undeterminateTimer.isRunning()) {
            this.undeterminateTimer.stop();
            return true;
        }
        return false;
    }

    private class TimerListener
    implements ActionListener {
        private TimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractBusyIcon.this.frame++;
            if (AbstractBusyIcon.this.frame >= AbstractBusyIcon.this.frameCount) {
                AbstractBusyIcon.this.frame = 0;
            }
            AbstractBusyIcon.this.repaint(true);
        }
    }

    private class ModelListener
    implements ChangeListener {
        private ModelListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            BoundedRangeModel boundedRangeModel = AbstractBusyIcon.this.getModel();
            boolean bl = AbstractBusyIcon.this.refreshUndeterminateTimer();
            if (boundedRangeModel != null && boundedRangeModel.getValue() == boundedRangeModel.getMaximum() && AbstractBusyIcon.this.lastRatio < 1.0f) {
                bl = true;
            }
            AbstractBusyIcon.this.repaint(bl);
        }
    }
}

