/*
 * Decompiled with CFR 0.152.
 */
package org.divxdede.swing.busy;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.Scrollable;
import org.divxdede.swing.busy.BusyModel;
import org.divxdede.swing.busy.DefaultBusyModel;
import org.divxdede.swing.busy.ui.BasicBusyLayerUI;
import org.divxdede.swing.busy.ui.BusyLayerUI;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;

public class JBusyComponent<C extends JComponent>
extends JComponent
implements Scrollable {
    private JXLayer<JComponent> layer = null;
    private BusyLayerUI ui = null;

    public JBusyComponent() {
        this(null);
    }

    public JBusyComponent(C c) {
        this(c, new BasicBusyLayerUI());
    }

    public JBusyComponent(C c, BusyLayerUI busyLayerUI) {
        this.layer = new JXLayer(c);
        super.setLayout(new BorderLayout());
        super.add((Component)this.layer, "Center");
        super.setOpaque(false);
        this.setBusyLayerUI(busyLayerUI);
        this.setBusyModel(new DefaultBusyModel());
    }

    public C getView() {
        return (C)((JComponent)this.layer.getView());
    }

    public void setView(C c) {
        this.layer.setView(c);
    }

    public BusyLayerUI getBusyLayerUI() {
        return this.ui;
    }

    public void setBusyLayerUI(BusyLayerUI busyLayerUI) {
        if (busyLayerUI == null) {
            busyLayerUI = new BasicBusyLayerUI();
        } else if (!(busyLayerUI instanceof LayerUI)) {
            throw new IllegalArgumentException("newUI must subclass LayerUI");
        }
        BusyModel busyModel = null;
        if (this.getBusyLayerUI() != null) {
            busyModel = this.getBusyLayerUI().getBusyModel();
            this.getBusyLayerUI().setBusyModel(null);
        }
        this.ui = busyLayerUI;
        this.layer.setUI((LayerUI)this.getBusyLayerUI());
        if (this.getBusyLayerUI() != null) {
            this.getBusyLayerUI().setBusyModel(busyModel);
        }
    }

    public void setBusyModel(BusyModel busyModel) {
        BusyLayerUI busyLayerUI = this.getBusyLayerUI();
        if (busyLayerUI == null) {
            throw new IllegalStateException("Can't set a BusyModel on a JBusyComponent without a BusyLayerUI");
        }
        busyLayerUI.setBusyModel(busyModel);
    }

    public BusyModel getBusyModel() {
        BusyLayerUI busyLayerUI = this.getBusyLayerUI();
        if (busyLayerUI == null) {
            return null;
        }
        return busyLayerUI.getBusyModel();
    }

    public boolean isBusy() {
        return this.getBusyModel() != null && this.getBusyModel().isBusy();
    }

    public void setBusy(boolean bl) {
        BusyModel busyModel = this.getBusyModel();
        if (busyModel != null) {
            busyModel.setBusy(bl);
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        if (this.getView() instanceof Scrollable) {
            return ((Scrollable)this.getView()).getPreferredScrollableViewportSize();
        }
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (this.getView() instanceof Scrollable) {
            return ((Scrollable)this.getView()).getScrollableUnitIncrement(rectangle, n, n2);
        }
        return 1;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (this.getView() instanceof Scrollable) {
            return ((Scrollable)this.getView()).getScrollableBlockIncrement(rectangle, n, n2);
        }
        return 1;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.getView() instanceof Scrollable) {
            return ((Scrollable)this.getView()).getScrollableTracksViewportWidth();
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getView() instanceof Scrollable) {
            return ((Scrollable)this.getView()).getScrollableTracksViewportHeight();
        }
        return false;
    }

    @Override
    public Component add(Component component) {
        throw new UnsupportedOperationException("JBusyComponent.add() is not supported.");
    }

    @Override
    public void remove(Component component) {
        throw new UnsupportedOperationException("JBusyComponent.remove(Component) is not supported.");
    }

    @Override
    public void removeAll() {
        throw new UnsupportedOperationException("JBusyComponent.removeAll() is not supported.");
    }
}

