/*
 * Decompiled with CFR 0.152.
 */
package org.divxdede.swing.busy;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.SwingWorker;
import org.divxdede.swing.busy.DefaultBusyModel;

public class FutureBusyModel
extends DefaultBusyModel {
    private ExecutorService service = null;
    private int ticket = 0;
    private Future trackedFuture = null;
    private Future trackerFuture = null;
    private PropertyChangeListener listener = new PropertyChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            FutureBusyModel futureBusyModel = FutureBusyModel.this;
            synchronized (futureBusyModel) {
                if (propertyChangeEvent.getSource() == FutureBusyModel.this.trackedFuture && propertyChangeEvent.getSource() instanceof SwingWorker && propertyChangeEvent.getPropertyName().equals("progress")) {
                    SwingWorker swingWorker = (SwingWorker)propertyChangeEvent.getSource();
                    FutureBusyModel.this.setValue(swingWorker.getProgress());
                }
            }
        }
    };

    public FutureBusyModel() {
        this.setAutoCompletionEnabled(false);
    }

    public synchronized void setFuture(Future future) {
        this.setFuture(future, true);
    }

    @Override
    public final void setBusy(boolean bl) {
    }

    private synchronized int setBusyImpl(boolean bl) {
        super.setBusy(bl);
        return ++this.ticket;
    }

    private synchronized boolean compareAndSetBusy(boolean bl, int n) {
        if (n == this.ticket) {
            this.setBusyImpl(bl);
            return true;
        }
        return false;
    }

    public synchronized void setFuture(Future future, boolean bl) {
        this.unregister();
        this.setCancellable(bl);
        this.register(future);
    }

    private void register(Future future) {
        Runnable runnable;
        this.trackedFuture = future;
        if (this.trackedFuture instanceof SwingWorker) {
            this.setDeterminate(true);
            this.setMinimum(0);
            this.setMaximum(100);
            runnable = (SwingWorker)this.trackedFuture;
            ((SwingWorker)runnable).addPropertyChangeListener(this.listener);
        } else {
            this.setDeterminate(false);
        }
        if (this.trackedFuture != null) {
            runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int n = 0;
                    try {
                        Future future = FutureBusyModel.this.trackedFuture;
                        while (!future.isDone()) {
                            n = FutureBusyModel.this.setBusyImpl(true);
                            try {
                                future.get();
                            }
                            catch (Exception exception) {
                                if (future == FutureBusyModel.this.trackedFuture) continue;
                                break;
                            }
                        }
                    }
                    finally {
                        FutureBusyModel.this.compareAndSetBusy(false, n);
                    }
                }
            };
            if (this.service == null) {
                this.service = Executors.newSingleThreadExecutor();
            }
            this.trackerFuture = this.service.submit(runnable);
        } else {
            this.setBusyImpl(false);
        }
    }

    private synchronized void unregister() {
        if (this.trackedFuture != null && this.trackedFuture instanceof SwingWorker) {
            SwingWorker swingWorker = (SwingWorker)this.trackedFuture;
            swingWorker.removePropertyChangeListener(this.listener);
        }
        this.setDeterminate(false);
        this.trackedFuture = null;
        if (this.trackerFuture != null) {
            this.trackerFuture.cancel(true);
            this.trackerFuture = null;
        }
    }

    @Override
    public synchronized void cancel() {
        Future future = this.trackedFuture;
        if (future != null) {
            future.cancel(true);
        }
    }

    public synchronized void dispose() {
        this.setFuture(null, false);
        if (this.service != null) {
            this.service.shutdownNow();
            this.service = null;
        }
    }
}

