/*
 * Decompiled with CFR 0.152.
 */
package org.divxdede.swing.busy;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.SwingUtilities;
import org.divxdede.swing.busy.BusyModel;

public class DefaultBusyModel
extends DefaultBoundedRangeModel
implements BusyModel {
    private boolean busyState = false;
    private boolean determinateState = false;
    private boolean autoCompletionState = false;
    private boolean cancellableState = false;
    private String description = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBusy(boolean bl) {
        boolean bl2 = this.isBusy();
        this.busyState = bl;
        if (bl2 != this.isBusy()) {
            if (this.isBusy() && this.isDeterminate() && this.isAutoCompletionEnabled()) {
                this.setValue(this.getMinimum());
            }
            try {
                if (this.isBusy()) {
                    this.fireActionPerformed(new ActionEvent(this, 1, "Start", System.currentTimeMillis(), 0));
                } else {
                    this.fireActionPerformed(new ActionEvent(this, 3, "Stop", System.currentTimeMillis(), 0));
                }
            }
            finally {
                this.fireStateChanged();
            }
        }
    }

    @Override
    public boolean isBusy() {
        return this.busyState;
    }

    @Override
    public void setValue(int n) {
        super.setValue(n);
        if (this.isDeterminate() && this.isAutoCompletionEnabled() && this.getValue() >= this.getMaximum()) {
            this.setBusy(false);
        }
    }

    @Override
    public void setDeterminate(boolean bl) {
        boolean bl2 = this.isDeterminate();
        this.determinateState = bl;
        if (bl2 != this.isDeterminate()) {
            this.fireStateChanged();
        }
    }

    @Override
    public boolean isDeterminate() {
        return this.determinateState;
    }

    public void setAutoCompletionEnabled(boolean bl) {
        boolean bl2 = this.isAutoCompletionEnabled();
        this.autoCompletionState = bl;
        if (bl2 != this.isAutoCompletionEnabled()) {
            this.fireStateChanged();
        }
    }

    public boolean isAutoCompletionEnabled() {
        return this.autoCompletionState;
    }

    @Override
    public boolean isCancellable() {
        return this.cancellableState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        if (!this.isCancellable()) {
            throw new IllegalStateException("this model is not cancellable");
        }
        try {
            this.fireActionPerformed(new ActionEvent(this, 2, "Cancel", System.currentTimeMillis(), 0));
        }
        finally {
            this.setBusy(false);
        }
    }

    @Override
    public void setCancellable(boolean bl) {
        boolean bl2 = this.isCancellable();
        this.cancellableState = bl;
        if (bl2 != this.isCancellable()) {
            this.fireStateChanged();
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        String string2 = string;
        this.description = string;
        if (string2 != this.description) {
            if (string2 != null && this.description != null && string2.equals(this.description)) {
                return;
            }
            this.fireStateChanged();
        }
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    @Override
    protected void fireStateChanged() {
        if (!SwingUtilities.isEventDispatchThread()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    DefaultBusyModel.this.fireStateChanged();
                }
            };
            SwingUtilities.invokeLater(runnable);
            return;
        }
        super.fireStateChanged();
    }

    protected void fireActionPerformed(final ActionEvent actionEvent) {
        if (!SwingUtilities.isEventDispatchThread()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    DefaultBusyModel.this.fireActionPerformed(actionEvent);
                }
            };
            SwingUtilities.invokeLater(runnable);
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ActionListener.class) continue;
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
        }
    }
}

