/*
 * Decompiled with CFR 0.152.
 */
package org.divxdede.swing.busy;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.divxdede.swing.RemainingTimeMonitor;
import org.divxdede.swing.busy.BusyModel;
import org.divxdede.swing.busy.DefaultBusyModel;

public abstract class BusySwingWorker<T, V>
extends SwingWorker<T, V> {
    private final StateAndProgressListener listener = new StateAndProgressListener();
    private BusyModel model = null;
    private final BoundedRangeModel progress = new DefaultBoundedRangeModel();

    public BusySwingWorker(BusyModel busyModel) {
        this.addPropertyChangeListener(this.listener);
        this.setBusyModel(busyModel);
    }

    public BusySwingWorker() {
        this(BusySwingWorker.createDefaultBusyModel());
    }

    public final BusyModel getBusyModel() {
        return this.model;
    }

    public final void setBusyModel(BusyModel busyModel) {
        BusyModel busyModel2 = this.getBusyModel();
        if (busyModel2 != null) {
            busyModel2.removeActionListener(this.listener);
        }
        this.model = busyModel;
        if (this.model != null) {
            this.model.addActionListener(this.listener);
        }
        this.firePropertyChange("busyModel", busyModel2, this.getBusyModel());
    }

    private static BusyModel createDefaultBusyModel() {
        DefaultBusyModel defaultBusyModel = new DefaultBusyModel();
        defaultBusyModel.setDeterminate(false);
        defaultBusyModel.setCancellable(true);
        defaultBusyModel.setMinimum(0);
        defaultBusyModel.setMaximum(100);
        return defaultBusyModel;
    }

    public BoundedRangeModel getProgressModel() {
        return this.progress;
    }

    private class StateAndProgressListener
    implements PropertyChangeListener,
    ActionListener,
    ChangeListener {
        private StateAndProgressListener() {
        }

        @Override
        public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
            if (!SwingUtilities.isEventDispatchThread()) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        StateAndProgressListener.this.propertyChange(propertyChangeEvent);
                    }
                };
                SwingUtilities.invokeLater(runnable);
                return;
            }
            if (propertyChangeEvent.getPropertyName().equals("state")) {
                SwingWorker.StateValue stateValue = (SwingWorker.StateValue)((Object)propertyChangeEvent.getNewValue());
                switch (stateValue) {
                    case DONE: {
                        BusySwingWorker.this.getBusyModel().setBusy(false);
                        BusySwingWorker.this.progress.removeChangeListener(this);
                        break;
                    }
                    case PENDING: {
                        break;
                    }
                    case STARTED: {
                        BusySwingWorker.this.getBusyModel().setBusy(true);
                        BusySwingWorker.this.getBusyModel().setValue(BusySwingWorker.this.getBusyModel().getMinimum());
                        BusySwingWorker.this.progress.addChangeListener(this);
                    }
                }
            } else if (propertyChangeEvent.getPropertyName().equals("progress")) {
                BusySwingWorker.this.getBusyModel().setDeterminate(true);
                Integer n = (Integer)propertyChangeEvent.getNewValue();
                BusySwingWorker.this.getBusyModel().setValue(this.scale(n.intValue(), BusySwingWorker.this.getBusyModel()));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == BusySwingWorker.this.getBusyModel() && actionEvent.getID() == 2) {
                BusySwingWorker.this.cancel(true);
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            BoundedRangeModel boundedRangeModel = BusySwingWorker.this.getProgressModel();
            if (changeEvent.getSource() == boundedRangeModel) {
                BusySwingWorker.this.setProgress(Math.round(RemainingTimeMonitor.getRatio(BusySwingWorker.this.getProgressModel()) * 100.0f));
            }
        }

        private int scale(float f, BusyModel busyModel) {
            float f2 = busyModel.getMaximum() - busyModel.getMinimum();
            float f3 = f * (f2 / 100.0f) + (float)busyModel.getMinimum();
            return Math.round(f3);
        }
    }
}

