/*
 * Decompiled with CFR 0.152.
 */
package org.divxdede.swing;

import com.google.common.collect.Queues;
import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import javax.swing.BoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RemainingTimeMonitor {
    private BoundedRangeModel model = null;
    private static final long MINIMUM_SAMPLE_DELAY = 1000L;
    private static final long MINIMUM_INITIAL_SAMPLE_DELAY = 100L;
    private static final int SAMPLE_COUNT = 10;
    private Deque<Sample> samples = null;
    private Sample currentSample = null;
    private Sample lastSampleUsed = null;
    private long lastRemainingTimeResult = -1L;
    private long whenLastRemainingTimeResult = 0L;
    private ChangeListener listener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            RemainingTimeMonitor.this.tick();
        }
    };

    public RemainingTimeMonitor(BoundedRangeModel boundedRangeModel) {
        this.model = boundedRangeModel;
        this.samples = Queues.newLinkedBlockingDeque((int)10);
        this.model.addChangeListener(this.listener);
    }

    public BoundedRangeModel getModel() {
        return this.model;
    }

    private synchronized void tick() {
        if (this.currentSample == null) {
            this.currentSample = new Sample(this.getCurrentRatio());
            return;
        }
        long l = System.currentTimeMillis();
        long l2 = l - this.currentSample.getStartTime();
        if (this.samples.size() < 5 && l2 >= 100L || l2 >= 1000L) {
            float f = this.getCurrentRatio();
            this.currentSample.end(f);
            this.samples.add(this.currentSample);
            this.currentSample = new Sample(f);
        }
        this.disposeIfCompleted();
    }

    public synchronized void dispose() {
        if (this.listener != null) {
            this.getModel().removeChangeListener(this.listener);
            this.listener = null;
        }
        this.samples.clear();
        this.currentSample = null;
        this.lastSampleUsed = null;
        this.lastRemainingTimeResult = 0L;
    }

    public synchronized boolean hasNewerEstimation() {
        return this.lastSampleUsed != this.samples.getLast();
    }

    public long getRemainingTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.getRemainingTime(), TimeUnit.MILLISECONDS);
    }

    public synchronized long getRemainingTime() {
        if (!this.hasNewerEstimation()) {
            if (this.lastRemainingTimeResult == -1L || this.lastRemainingTimeResult == Long.MAX_VALUE) {
                return this.lastRemainingTimeResult;
            }
            return Math.max(0L, this.lastRemainingTimeResult - (System.currentTimeMillis() - this.whenLastRemainingTimeResult));
        }
        if (this.samples.isEmpty()) {
            this.lastRemainingTimeResult = -1L;
            this.whenLastRemainingTimeResult = System.currentTimeMillis();
            this.lastSampleUsed = null;
            return -1L;
        }
        if (this.disposeIfCompleted()) {
            return 0L;
        }
        float f = RemainingTimeMonitor.getRatio(this.getModel());
        float f2 = 0.0f;
        long l = 0L;
        Iterator<Sample> iterator = this.samples.iterator();
        while (iterator.hasNext()) {
            Sample sample;
            this.lastSampleUsed = sample = iterator.next();
            f2 += this.lastSampleUsed.getAdvance();
            l += this.lastSampleUsed.getDuration();
        }
        float f3 = 1.0f - f;
        this.lastRemainingTimeResult = f2 < 1.0E-4f ? Long.MAX_VALUE : (long)(1.0f / f2 * (float)l * f3);
        this.whenLastRemainingTimeResult = System.currentTimeMillis();
        return this.lastRemainingTimeResult;
    }

    public static float getRatio(BoundedRangeModel boundedRangeModel) {
        if (boundedRangeModel != null) {
            int n = boundedRangeModel.getMaximum() - boundedRangeModel.getMinimum();
            int n2 = boundedRangeModel.getValue() + boundedRangeModel.getExtent();
            return (float)n2 / (float)n;
        }
        return 0.0f;
    }

    private float getCurrentRatio() {
        return RemainingTimeMonitor.getRatio(this.getModel());
    }

    private boolean disposeIfCompleted() {
        if (this.getModel().getValue() + this.getModel().getExtent() >= this.getModel().getMaximum()) {
            this.dispose();
            return true;
        }
        return false;
    }

    private static class Sample {
        private long duration;
        private float advance;
        private long startTime = System.currentTimeMillis();
        private float startRatio;
        private long endTime;

        public Sample(float f) {
            this.startRatio = f;
        }

        public void end(float f) {
            this.endTime = System.currentTimeMillis();
            this.duration = this.endTime - this.startTime;
            this.advance = f - this.startRatio;
        }

        public long getDuration() {
            return this.duration;
        }

        public float getAdvance() {
            return this.advance;
        }

        public long getStartTime() {
            return this.startTime;
        }
    }
}

