/*
 * Decompiled with CFR 0.152.
 */
package org.divxdede.swing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BoundedRangeModelHub
implements ChangeListener,
Iterable<BoundedRangeModel> {
    private List<WeightBoundedRangeModel> subs = new ArrayList<WeightBoundedRangeModel>();
    private BoundedRangeModel master = null;
    private float totalWeight = 0.0f;
    private boolean changing = false;

    public BoundedRangeModelHub() {
        this(null);
    }

    public BoundedRangeModelHub(BoundedRangeModel boundedRangeModel) {
        this.setMasterBoundedRangeModel(boundedRangeModel);
    }

    public synchronized void setMasterBoundedRangeModel(BoundedRangeModel boundedRangeModel) {
        BoundedRangeModel boundedRangeModel2 = this.master;
        if (boundedRangeModel2 != null) {
            boundedRangeModel2.removeChangeListener(this);
        }
        this.master = boundedRangeModel;
        if (this.master == null) {
            for (WeightBoundedRangeModel weightBoundedRangeModel : this.subs) {
                weightBoundedRangeModel.getModel().removeChangeListener(this);
            }
        } else {
            this.master.addChangeListener(this);
            if (boundedRangeModel2 == null) {
                for (WeightBoundedRangeModel weightBoundedRangeModel : this.subs) {
                    weightBoundedRangeModel.getModel().addChangeListener(this);
                }
            }
        }
        if (boundedRangeModel2 != this.master) {
            this.stateChanged(null);
        }
    }

    public synchronized BoundedRangeModel getMasterBoundedRangeModel() {
        return this.master;
    }

    public synchronized BoundedRangeModel createFragment(float f) {
        return this.addFragment(new DefaultBoundedRangeModel(), f);
    }

    public synchronized BoundedRangeModel addFragment(BoundedRangeModel boundedRangeModel, float f) {
        if (boundedRangeModel == null) {
            throw new NullPointerException();
        }
        if (f < 0.0f) {
            throw new IllegalArgumentException("weight must be positive");
        }
        WeightBoundedRangeModel weightBoundedRangeModel = new WeightBoundedRangeModel(boundedRangeModel, f);
        if (this.master != null) {
            weightBoundedRangeModel.getModel().addChangeListener(this);
        }
        this.subs.add(weightBoundedRangeModel);
        this.totalWeight += f;
        this.stateChanged(null);
        return weightBoundedRangeModel.getModel();
    }

    public synchronized BoundedRangeModel removeFragment(int n) {
        WeightBoundedRangeModel weightBoundedRangeModel = this.subs.remove(n);
        if (weightBoundedRangeModel != null) {
            weightBoundedRangeModel.getModel().removeChangeListener(this);
            this.totalWeight -= weightBoundedRangeModel.getWeight();
            this.stateChanged(null);
            return weightBoundedRangeModel.getModel();
        }
        return null;
    }

    public synchronized BoundedRangeModel[] getFragments() {
        BoundedRangeModel[] boundedRangeModelArray = new BoundedRangeModel[this.subs.size()];
        for (int i = 0; i < this.subs.size(); ++i) {
            boundedRangeModelArray[i] = this.subs.get(i).getModel();
        }
        return boundedRangeModelArray;
    }

    @Override
    public synchronized Iterator<BoundedRangeModel> iterator() {
        return Arrays.asList(this.getFragments()).iterator();
    }

    public synchronized int size() {
        return this.subs.size();
    }

    public synchronized int indexOf(BoundedRangeModel boundedRangeModel) {
        for (int i = 0; i < this.subs.size(); ++i) {
            if (boundedRangeModel != this.subs.get(i).getModel()) continue;
            return i;
        }
        return -1;
    }

    public synchronized BoundedRangeModel getFragment(int n) {
        return this.subs.get(n).getModel();
    }

    public synchronized float getWeight(int n) {
        return this.subs.get(n).getWeight();
    }

    public synchronized void setWeight(int n, float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("Weight must be positive");
        }
        float f2 = this.getWeight(n);
        this.subs.get(n).setWeight(f);
        this.totalWeight = this.totalWeight - f2 + f;
        this.stateChanged(null);
    }

    public synchronized float getTotalWeight() {
        return this.totalWeight;
    }

    public void dispose() {
        this.setMasterBoundedRangeModel(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stateChanged(ChangeEvent changeEvent) {
        if (this.changing) {
            return;
        }
        this.changing = true;
        try {
            if (this.getMasterBoundedRangeModel() == null) {
                return;
            }
            int n = 0;
            for (WeightBoundedRangeModel weightBoundedRangeModel : this.subs) {
                n += weightBoundedRangeModel.getExtentPartFor(this.getTotalWeight(), this.getMasterBoundedRangeModel());
            }
            this.getMasterBoundedRangeModel().setValue(n);
        }
        finally {
            this.changing = false;
        }
    }

    public static BoundedRangeModelHub split(BoundedRangeModel boundedRangeModel, int n) {
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = 1.0f;
        }
        return BoundedRangeModelHub.split(boundedRangeModel, fArray);
    }

    public static BoundedRangeModelHub split(BoundedRangeModel boundedRangeModel, Number ... numberArray) {
        float[] fArray = new float[numberArray.length];
        for (int i = 0; i < numberArray.length; ++i) {
            fArray[i] = numberArray[i].floatValue();
        }
        return BoundedRangeModelHub.split(boundedRangeModel, fArray);
    }

    public static BoundedRangeModelHub split(BoundedRangeModel boundedRangeModel, float ... fArray) {
        if (fArray == null) {
            return null;
        }
        BoundedRangeModelHub boundedRangeModelHub = new BoundedRangeModelHub(boundedRangeModel);
        for (int i = 0; i < fArray.length; ++i) {
            boundedRangeModelHub.createFragment(fArray[i]);
        }
        return boundedRangeModelHub;
    }

    private static class WeightBoundedRangeModel {
        private BoundedRangeModel model = null;
        private float weight = 0.0f;

        private WeightBoundedRangeModel(BoundedRangeModel boundedRangeModel, float f) {
            this.model = boundedRangeModel;
            this.weight = f;
        }

        public int getExtentPartFor(float f, BoundedRangeModel boundedRangeModel) {
            int n = this.getModel().getMaximum() - this.getModel().getMinimum();
            int n2 = this.getModel().getValue() + this.getModel().getExtent() - this.getModel().getMinimum();
            float f2 = (float)n2 / (float)n;
            int n3 = boundedRangeModel.getMaximum() - boundedRangeModel.getMinimum() - boundedRangeModel.getExtent();
            float f3 = f2 * (this.weight / f);
            return (int)((float)n3 * f3);
        }

        private float getWeight() {
            return this.weight;
        }

        private void setWeight(float f) {
            this.weight = f;
        }

        public BoundedRangeModel getModel() {
            return this.model;
        }
    }
}

