/*
 * Decompiled with CFR 0.152.
 */
package com.ettrema.logging;

import java.io.File;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class Log4JMonitor
implements Runnable {
    private static Logger log = Logger.getLogger(Log4JMonitor.class);
    boolean interruped;
    private final long checkIntervalMillis;
    private File file;
    private long lastModified = 0L;

    public Log4JMonitor(long checkIntervalMillis, File file) {
        this.checkIntervalMillis = checkIntervalMillis;
        this.file = file;
    }

    @Override
    public void run() {
        System.out.println("Initialize " + this.file.getAbsolutePath());
        this.lastModified = this.file.lastModified();
        this.monitor();
    }

    private void monitor() {
        log.info((Object)"Starting log4j monitor");
        while (!this.interruped) {
            long temp = this.file.lastModified();
            if (this.lastModified != temp) {
                log.info((Object)("Initialize log4j configuration " + this.file.getAbsolutePath()));
                LogManager.resetConfiguration();
                PropertyConfigurator.configure((String)this.file.getAbsolutePath());
                this.lastModified = temp;
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Log4j configuration is not modified: " + this.file.getAbsolutePath() + " - " + temp));
            }
            try {
                Thread.sleep(this.checkIntervalMillis);
            }
            catch (InterruptedException e) {
                this.interruped = true;
            }
        }
        log.info((Object)"Shutting down log4j monitor");
    }

    public long getCheckIntervalMillis() {
        return this.checkIntervalMillis;
    }

    public boolean isInterruped() {
        return this.interruped;
    }

    public void setInterruped(boolean interruped) {
        this.interruped = interruped;
    }
}

