/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.xml;

import com.bradmcevoy.utils.XmlUtils2;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.HtmlXmlOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXParseException;

public class XmlHelper {
    private static final Logger log = LoggerFactory.getLogger(XmlHelper.class);
    public static final String DTD = "<!DOCTYPE root PUBLIC '-//MyDT//DTD MYDTD-XML//MYDTD' 'xhtml-lat1.ent'>";

    private XmlHelper() {
    }

    public static String getAllText(Element el) {
        Format format = Format.getRawFormat();
        List children = el.getContent();
        if (children == null) {
            return "";
        }
        HtmlXmlOutputter outputter = new HtmlXmlOutputter(format);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(bout);
        for (Object o : children) {
            if (o instanceof CDATA) {
                CDATA cd = (CDATA)o;
                String s = cd.getText();
                pw.print(s);
                continue;
            }
            if (o instanceof Element) {
                String xml = XmlHelper.toString((Element)o, format);
                pw.print(xml);
                continue;
            }
            if (o instanceof Text) {
                try {
                    Text t = (Text)o;
                    outputter.output(t, (Writer)pw);
                    continue;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            if (o instanceof EntityRef) {
                EntityRef ref = (EntityRef)o;
                pw.print("&" + ref.getName() + ";");
                continue;
            }
            if (o == null) continue;
            log.warn("unsupported XML type: " + o.getClass());
        }
        pw.flush();
        try {
            String s = bout.toString("UTF-8");
            return s;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String toString(Element el) {
        return XmlHelper.toString(el, Format.getPrettyFormat());
    }

    public static String toString(Element el, Format format) {
        HtmlXmlOutputter outputter = new HtmlXmlOutputter(format);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            outputter.output(el, (OutputStream)out);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        try {
            String s = out.toString("UTF-8");
            return s;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Couldnt output to UTF-8", ex);
        }
    }

    public static List getContent(String text) {
        Document doc;
        String xml = "<?xml version='1.0' encoding='UTF-8'?><!DOCTYPE root PUBLIC '-//MyDT//DTD MYDTD-XML//MYDTD' 'xhtml-lat1.ent'><a>" + text + "</a>";
        try {
            XmlUtils2 utils = new XmlUtils2();
            doc = utils.getJDomDocument(new ByteArrayInputStream(xml.getBytes("UTF-8")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (Throwable e) {
            if (e instanceof SAXParseException || e instanceof JDOMException) {
                log.debug("caught invalid markup, wrapping with CDATA", e);
                ArrayList<CDATA> list = new ArrayList<CDATA>();
                list.add(new CDATA(text));
                return list;
            }
            throw new RuntimeException(e);
        }
        List list = doc.getRootElement().getContent();
        return XmlHelper.detach(list);
    }

    public static Document getJDomDocument(String s) throws JDOMException {
        try {
            StringReader sr = new StringReader(s);
            SAXBuilder builder = new SAXBuilder();
            builder.setExpandEntities(false);
            return builder.build((Reader)sr);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static List<Content> detach(List list) {
        List<Content> contents = XmlHelper.contentList(list);
        for (Content c : contents) {
            c.detach();
        }
        return contents;
    }

    private static List<Content> contentList(List list) {
        ArrayList<Content> contents = new ArrayList<Content>();
        for (Object o : list) {
            if (!(o instanceof Content)) continue;
            Content c = (Content)o;
            contents.add(c);
        }
        return contents;
    }
}

