/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.utils;

import com.bradmcevoy.common.Path;
import com.bradmcevoy.utils.ElementList;
import com.bradmcevoy.utils.FileUtils;
import com.bradmcevoy.utils.ReflectionUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlUtils2 {
    private static final Logger log = LoggerFactory.getLogger(XmlUtils2.class);
    private static final Properties entities;
    private static List<String> knownSystemIds;
    private DocumentBuilderFactory mDomFactory = null;
    private DocumentBuilder mDomBuilder = null;

    public static List<org.jdom.Element> children(org.jdom.Element e2, String elementName) {
        List list = e2.getChildren(elementName);
        ArrayList<org.jdom.Element> els = new ArrayList<org.jdom.Element>();
        for (Object o : list) {
            els.add((org.jdom.Element)o);
        }
        return els;
    }

    public Document getJDomDocument(File f) throws FileNotFoundException, JDOMException {
        Document document;
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(f);
            BufferedInputStream bufin = new BufferedInputStream(fin);
            document = this.getJDomDocument(bufin);
        }
        catch (IOException ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                FileUtils.close(fin);
                throw throwable;
            }
        }
        FileUtils.close(fin);
        return document;
    }

    public Document getJDomDocument(InputStream fin) throws JDOMException {
        try {
            SAXBuilder builder = new SAXBuilder();
            builder.setExpandEntities(false);
            builder.setEntityResolver((EntityResolver)new MyEntityResolver());
            return builder.build(fin);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Document getJDomDocument(String s) throws JDOMException {
        ByteArrayInputStream bin = null;
        try {
            bin = new ByteArrayInputStream(s.getBytes("UTF-8"));
            Document document = this.getJDomDocument(bin);
            return document;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                bin.close();
            }
            catch (IOException ex) {
                log.error("ex", (Throwable)ex);
            }
        }
    }

    public String getXml(Document doc) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.transformDocument((OutputStream)out, doc);
        return out.toString();
    }

    public String getXml(org.jdom.Element el) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.transformDocument((OutputStream)out, el);
        return out.toString();
    }

    public void saveXMLDocument(OutputStream out, Document doc) {
        Format format = Format.getPrettyFormat();
        XMLOutputter outputter = new XMLOutputter(format);
        try {
            outputter.output(doc, out);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void transformDocument(PrintWriter pw, Document doc) {
        Format f = Format.getPrettyFormat();
        f.setTextMode(Format.TextMode.PRESERVE);
        XMLOutputter outputter = new XMLOutputter(f);
        try {
            outputter.output(doc, (Writer)pw);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void transformElement(PrintWriter pw, org.jdom.Element el) {
        Format f = Format.getPrettyFormat();
        f.setTextMode(Format.TextMode.PRESERVE);
        XMLOutputter outputter = new XMLOutputter(f);
        try {
            outputter.output(el, (Writer)pw);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void transformDocument(OutputStream out, Document doc) {
        Format f = Format.getPrettyFormat();
        f.setTextMode(Format.TextMode.PRESERVE);
        XMLOutputter outputter = new XMLOutputter(f);
        try {
            outputter.output(doc, out);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void transformDocument(OutputStream out, org.jdom.Element el) {
        Format f = Format.getPrettyFormat();
        f.setTextMode(Format.TextMode.PRESERVE);
        XMLOutputter outputter = new XMLOutputter(f);
        try {
            outputter.output(el, out);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public synchronized DocumentBuilderFactory domBuilderFactory() {
        if (this.mDomFactory == null) {
            this.mDomFactory = DocumentBuilderFactory.newInstance();
            this.mDomFactory.setValidating(false);
            this.mDomFactory.setExpandEntityReferences(false);
        }
        return this.mDomFactory;
    }

    public synchronized DocumentBuilder domBuilder() {
        try {
            if (this.mDomBuilder == null) {
                this.mDomBuilder = this.domBuilderFactory().newDocumentBuilder();
            }
            return this.mDomBuilder;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized org.w3c.dom.Document getDomDocument() {
        return this.domBuilder().newDocument();
    }

    public synchronized org.w3c.dom.Document getDomDocument(File file) throws FileNotFoundException, SAXException {
        try {
            FileReader xmlReader = new FileReader(file);
            InputSource xmlSource = new InputSource(xmlReader);
            return this.domBuilder().parse(xmlSource);
        }
        catch (FileNotFoundException fnf) {
            throw fnf;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized org.w3c.dom.Document getDomDocument(String xml) throws SAXParseException {
        try {
            this.domBuilder();
            DocumentBuilder documentBuilder = this.mDomBuilder;
            synchronized (documentBuilder) {
                BufferedReader xmlReader = new BufferedReader(new StringReader(xml));
                InputSource xmlSource = new InputSource(xmlReader);
                return this.domBuilder().parse(xmlSource);
            }
        }
        catch (SAXParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized org.w3c.dom.Document getDomDocument(InputSource is) {
        try {
            return this.domBuilder().parse(is);
        }
        catch (SAXException se) {
            throw new RuntimeException(se);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public synchronized org.w3c.dom.Document getDomDocument(InputStream is) throws SAXException {
        try {
            return this.domBuilder().parse(is);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static ElementList getElements(Element el, String tagName) {
        NodeList nodes = el.getChildNodes();
        ElementList elements = XmlUtils2.getElements(nodes);
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            Element elChild = (Element)it.next();
            if (elChild.getNodeName().equals(tagName)) continue;
            it.remove();
        }
        return elements;
    }

    public static Element getElement(Element el, String tagName) {
        for (Element elChild : XmlUtils2.getElementList(el.getChildNodes())) {
            if (!elChild.getNodeName().equals(tagName)) continue;
            return elChild;
        }
        return null;
    }

    public static ElementList getElements(NodeList nodes) {
        return new ElementList(nodes);
    }

    public static Collection<Node> getList(NodeList nodes) {
        ArrayList<Node> arr = new ArrayList<Node>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            arr.add(nodes.item(i));
        }
        return arr;
    }

    public static Collection<Element> getElementList(NodeList nodes) {
        return XmlUtils2.getElementList(nodes, null);
    }

    public static Collection<Element> getElementList(NodeList nodes, String tagName) {
        ArrayList<Element> arr = new ArrayList<Element>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (!(n instanceof Element)) continue;
            Element e = (Element)n;
            if (tagName != null && !tagName.equals(e.getNodeName())) continue;
            arr.add((Element)n);
        }
        return arr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveXMLDocument(File file, Document doc) throws FileNotFoundException {
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream fos = new FileOutputStream(file);
        try {
            XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
            try {
                outputter.output(doc, (OutputStream)fos);
            }
            catch (IOException e) {
                throw new RuntimeException(file.getAbsolutePath(), e);
            }
        }
        finally {
            try {
                fos.flush();
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveXMLDocument(File file, org.w3c.dom.Document doc) throws FileNotFoundException {
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream fos = new FileOutputStream(file);
        try {
            this.saveXMLDocument((OutputStream)fos, doc);
        }
        finally {
            try {
                fos.flush();
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    public void saveXMLDocument(OutputStream out, org.w3c.dom.Document doc) {
        this.transformDocument(out, doc);
    }

    public void transformDocument(Writer writer, org.w3c.dom.Document doc) {
        Element node = doc.getDocumentElement();
        StreamResult result = new StreamResult(writer);
        this.transformDocument(result, (Node)node);
    }

    public void transformDocument(OutputStream os, org.w3c.dom.Document doc) {
        this.transformDocument(os, (Node)doc.getDocumentElement());
    }

    public void transformDocument(OutputStream os, Node node) {
        this.transformDocument(os, node, false);
    }

    public void transformDocument(OutputStream os, Node node, boolean omitDeclaration) {
        StreamResult result = new StreamResult(os);
        this.transformDocument(result, node, omitDeclaration);
    }

    public void transformDocument(StreamResult result, Node node) {
        this.transformDocument(result, node, false);
    }

    public void transformDocument(StreamResult result, Node node, boolean omitDeclaration) {
        Transformer transformer;
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
        transformer.setOutputProperty("omit-xml-declaration", omitDeclaration ? "yes" : "no");
        DOMSource source = new DOMSource(node);
        try {
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    public String getChildXml(Node el) {
        StringBuilder sb = new StringBuilder();
        NodeList nl = el.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (i != 0) {
                sb.append("\n");
            }
            sb.append(this.getXml(n).trim());
        }
        return sb.toString();
    }

    public String getXml(Node el) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.transformDocument((OutputStream)os, el);
        String xml = os.toString();
        int start = xml.indexOf("?>");
        xml = xml.substring(start + 2);
        return xml;
    }

    public Element append(Element parent, String textOrXml) throws SAXParseException {
        StringBuffer xml = new StringBuffer("<a>").append(textOrXml).append("</a>");
        org.w3c.dom.Document docChild = this.getDomDocument(xml.toString());
        NodeList childNodes = docChild.getDocumentElement().getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node n = childNodes.item(i);
            parent.appendChild(parent.getOwnerDocument().importNode(n, true));
        }
        return parent;
    }

    public static String expandHtmlEntities(String s) {
        for (Object o : entities.keySet()) {
            String entity = (String)o;
            String val = entities.getProperty(entity);
            s = s.replaceAll(entity, val);
        }
        return s;
    }

    public static String htmlEntityEncode(String s) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                buf.append(c);
                continue;
            }
            buf.append("&#" + c + ";");
        }
        return buf.toString();
    }

    public Element getChild(Element el, String name) {
        NodeList list = el.getElementsByTagName(name);
        if (list == null || list.getLength() == 0) {
            return null;
        }
        Element elChild = (Element)list.item(0);
        return elChild;
    }

    public String getText(Element el) {
        StringBuilder sb = new StringBuilder();
        NodeList nodes = el.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (!(n instanceof Text)) continue;
            Text t = (Text)n;
            sb.append(t.getTextContent());
        }
        return sb.toString();
    }

    public boolean getBooleanAttribute(Element el, String attName) {
        String s = el.getAttribute(attName);
        if (s == null) {
            return false;
        }
        return s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes");
    }

    public String getTextData(Element el) {
        Text c = this.getChildOfType(el, Text.class);
        if (c == null) {
            return null;
        }
        return c.getData();
    }

    public String getCData(Element el) {
        CDATASection c = this.getChildOfType(el, CDATASection.class);
        if (c == null) {
            return null;
        }
        return c.getData();
    }

    public <T> T getChildOfType(Element el, Class<T> c) {
        for (Node n = el.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!c.isAssignableFrom(n.getClass())) continue;
            return (T)n;
        }
        return null;
    }

    public static Object restoreObject(org.jdom.Element el, Object parent) {
        String className = el.getAttributeValue("class");
        if (className == null || className.length() == 0) {
            throw new IllegalArgumentException("class is empty");
        }
        return ReflectionUtils.create(className, parent, (Object)el);
    }

    public static Object restoreObject(Element el, Object parent) {
        String className = el.getAttribute("class");
        if (className == null || className.length() == 0) {
            throw new IllegalArgumentException("class is empty");
        }
        return ReflectionUtils.create(className, parent, (Object)el);
    }

    public static void process(Node n, XmlNodeOperator r) {
        r.process(n);
        for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
            XmlUtils2.process(child, r);
        }
    }

    static {
        knownSystemIds = Arrays.asList("xhtml-lat1.ent", "xhtml-special.ent", "xhtml-symbol.ent", "xhtml1-strict.dtd");
        entities = new Properties();
        InputStream is = XmlUtils2.class.getResourceAsStream("entities.properties");
        try {
            entities.load(is);
        }
        catch (IOException ex) {
            System.out.println("Failed to load HTML entities from file entities.properties which should be in package com.bradmcevoy.utils");
            ex.printStackTrace();
        }
    }

    public static interface XmlNodeOperator {
        public void process(Node var1);
    }

    public class MyEntityResolver
    implements EntityResolver {
        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            Path p = Path.path(systemId);
            if (knownSystemIds.contains(p.getName())) {
                if (log.isTraceEnabled()) {
                    log.trace("using embedded resource: " + p.getName());
                }
                return new InputSource(this.getClass().getResourceAsStream("/" + p.getName()));
            }
            log.warn("entity resource not found: publicId: " + publicId + " systemId: " + systemId);
            return null;
        }
    }
}

