/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.utils;

import java.io.InputStream;
import java.net.URL;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Vector;

public class StringUtils {
    private Random random;

    public static java.sql.Date now() {
        return new java.sql.Date(new Date().getTime());
    }

    public static java.sql.Date addYear(java.sql.Date dt) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(dt.getTime()));
        cal.add(1, 1);
        return new java.sql.Date(cal.getTimeInMillis());
    }

    public static synchronized String getTextFromDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        return sdf.format(date);
    }

    public static synchronized String getTextFromDateTime(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        return sdf.format(date);
    }

    public static synchronized Date getDateFromText(String dt) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        sdf.setLenient(false);
        return sdf.parse(dt);
    }

    public static synchronized Date getDateAndTimeFromText(String dt) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm");
        return sdf.parse(dt);
    }

    public static synchronized Date getDateFromText(String day, String month, String year) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        String s = day + "/" + month + "/" + year;
        return sdf.parse(s);
    }

    public static synchronized Date getDateAndTimeFromText(String day, String month, String year, String hour, String minute) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm");
        String s = day + "/" + month + "/" + year + " " + hour + ":" + minute;
        return sdf.parse(s);
    }

    public static synchronized Date getDateAndTimeFromText(int day, int month, int year, int hour, int minute) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm");
        String s = day + "/" + month + "/" + year + " " + hour + ":" + minute;
        return sdf.parse(s);
    }

    public static synchronized java.sql.Date addMonth(Calendar cal, int noOfMonths) {
        cal.add(2, noOfMonths);
        return StringUtils.getSQLDate(cal.getTime());
    }

    public static synchronized java.sql.Date addWeek(Calendar cal) {
        cal.add(7, 7);
        return StringUtils.getSQLDate(cal.getTime());
    }

    public static synchronized java.sql.Date getSQLDate(Date date) {
        if (date == null) {
            return null;
        }
        java.sql.Date sqlDate = new java.sql.Date(date.getTime());
        return sqlDate;
    }

    public static synchronized java.sql.Date getSQLDate(String strDate) throws ParseException {
        return StringUtils.getSQLDate(StringUtils.getDateFromText(strDate));
    }

    public static synchronized Date getDateFromSQLDate(java.sql.Date date) {
        if (date == null) {
            return null;
        }
        Date dt = new Date(date.getTime());
        return dt;
    }

    public static synchronized java.sql.Date getTodaysDate() {
        java.sql.Date date = new java.sql.Date(new Date().getTime());
        return date;
    }

    public static synchronized Timestamp getSystemClock() {
        Timestamp newTime = new Timestamp(new Date().getTime());
        return newTime;
    }

    public static synchronized Vector<String> split(String source, String token) {
        Vector<String> v = new Vector<String>();
        StringUtils._split(source, v, token);
        return v;
    }

    private static synchronized void _split(String source, Vector<String> v, String param) {
        int pos = source.indexOf(param);
        if (pos >= 0) {
            String id = source.substring(0, pos).trim();
            if (id.length() > 0) {
                v.add(id);
            }
            StringUtils._split(source.substring(pos + param.length(), source.length()), v, param);
        } else {
            String id = source.trim();
            if (id.length() > 0) {
                v.add(id);
            }
        }
    }

    public static String[] getResource(String name) throws Exception {
        Vector<String> v = new Vector<String>();
        URL url = StringUtils.class.getClassLoader().getResource(name);
        InputStream str = url.openStream();
        StringBuffer sb = new StringBuffer();
        int i = str.read();
        while (i > -1) {
            if (i == 10) {
                v.add(sb.toString());
                sb = new StringBuffer();
            } else if (i != 13) {
                sb.append((char)i);
            }
            i = str.read();
        }
        i = 0;
        String[] settings = new String[v.size()];
        Iterator it = v.iterator();
        while (it.hasNext()) {
            settings[i] = (String)it.next();
            ++i;
        }
        return settings;
    }

    public static String getResourceAsString(String name) throws Exception {
        Vector v = new Vector();
        URL url = StringUtils.class.getClassLoader().getResource(name);
        InputStream str = url.openStream();
        StringBuffer sb = new StringBuffer();
        int i = str.read();
        while (i > -1) {
            sb.append((char)i);
            i = str.read();
        }
        return sb.toString();
    }

    public static synchronized String[][] getResource(String name, int cols, String delimiter) throws Exception {
        int row = 0;
        int c = 0;
        String phase = "get resource";
        try {
            Vector<String> v = new Vector<String>();
            URL url = v.getClass().getClassLoader().getResource(name);
            phase = "open resource";
            InputStream str = url.openStream();
            phase = "read resource";
            StringBuffer sb = new StringBuffer();
            int i = str.read();
            while (i > -1) {
                if (i == 10) {
                    v.add(sb.toString());
                    sb = new StringBuffer();
                } else if (i != 13) {
                    sb.append((char)i);
                }
                i = str.read();
            }
            phase = "copy resource to array";
            String[][] vals = new String[v.size()][cols];
            for (String s1 : v) {
                Vector<String> v2 = StringUtils.split(s1, delimiter);
                Iterator<String> it2 = v2.iterator();
                c = 0;
                while (it2.hasNext()) {
                    String s2;
                    vals[row][c] = s2 = it2.next();
                }
            }
            return vals;
        }
        catch (Exception e) {
            throw new Exception("There was an error reading resource " + name + " in phase " + phase + ". Row=" + row + "; column=" + c);
        }
    }

    public static synchronized String replace(String source, String param, String value) {
        String s = "";
        Vector<String> v = new Vector<String>();
        StringUtils._replace(source, v, param, value);
        Iterator<String> it = v.iterator();
        while (it.hasNext()) {
            s = s + it.next();
        }
        return s;
    }

    private static synchronized void _replace(String source, Vector<String> v, String param, String value) {
        int pos = source.indexOf(param);
        if (pos >= 0) {
            String id = source.substring(0, pos);
            if (id.length() > 0) {
                v.add(id);
            }
            v.add(value);
            StringUtils._replace(source.substring(pos + param.length(), source.length()), v, param, value);
        } else {
            String id = source;
            if (id.length() > 0) {
                v.add(id);
            }
        }
    }

    public String systemFileSeperator() {
        return System.getProperty("file.separator");
    }

    public String randomMessage(String[] strings) {
        if (this.random == null) {
            this.random = new Random();
        }
        int i = this.random.nextInt(strings.length - 1);
        return strings[i];
    }

    public boolean isNumeric(String s) {
        try {
            Float.parseFloat(s);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public boolean in(String string, String[] list) {
        for (String s : list) {
            if (!string.equals(s)) continue;
            return true;
        }
        return false;
    }

    public static String toString(List<String> list, char delimiter) {
        if (list == null || list.size() == 0) {
            return "";
        }
        StringBuffer sb = null;
        for (String s : list) {
            if (sb == null) {
                sb = new StringBuffer();
            } else {
                sb.append(delimiter);
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static String toString(List<String> list) {
        return StringUtils.toString(list, ',');
    }

    public static List<String> fromString(String s) {
        return StringUtils.fromString(s, ',');
    }

    public static List<String> fromString(String s, char delimiter) {
        ArrayList<String> list = new ArrayList<String>();
        if (s == null || s.length() == 0) {
            return list;
        }
        for (String part : s.split("[" + delimiter + "]")) {
            list.add(part);
        }
        return list;
    }
}

