/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    private Region mUs;
    private Region mAus;
    private ThreadLocal<SimpleDateFormat> thSdf;
    public static String[] dayNames = new String[]{"Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"};
    public static String[] dayAbbrevs = new String[]{"Mon", "Tues", "Wed", "Thurs", "Fri", "Sat", "Sun"};
    public static final String DEFAULT_FORMAT = "dd/MM/yyyy HH:mm";

    public DateUtils() {
        this.thSdf = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                SimpleDateFormat sdf = new SimpleDateFormat(DateUtils.DEFAULT_FORMAT);
                sdf.setLenient(false);
                return sdf;
            }
        };
    }

    public DateUtils(final String dateFormat, final boolean includeTime) {
        this.thSdf = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                SimpleDateFormat sdf = includeTime ? new SimpleDateFormat(dateFormat + " HH:mm") : new SimpleDateFormat(dateFormat);
                sdf.setLenient(false);
                return sdf;
            }
        };
    }

    public Region us() {
        if (this.mUs == null) {
            this.mUs = new Region("MM/dd/yyyy");
        }
        return this.mUs;
    }

    public Region aus() {
        if (this.mAus == null) {
            this.mAus = new Region("dd/MM/yyyy");
        }
        return this.mAus;
    }

    public String getText(Date date) {
        if (date == null) {
            return "";
        }
        return this.thSdf.get().format(date);
    }

    public Date getDate(String dt) throws ParseException {
        if (dt == null || dt.length() == 0) {
            return null;
        }
        return this.thSdf.get().parse(dt);
    }

    public static java.sql.Date getSQLDate(Date dt) {
        if (dt == null) {
            return null;
        }
        return new java.sql.Date(dt.getTime());
    }

    public java.sql.Date getSQLDate(String strDate) throws ParseException {
        Date dt = this.getDate(strDate);
        return DateUtils.getSQLDate(dt);
    }

    public static java.sql.Date addDays(java.sql.Date dt, int num) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, num);
        return DateUtils.getSQLDate(cal.getTime());
    }

    public static Date addDays(Date dt, int num) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, num);
        return cal.getTime();
    }

    public String getDayName(int i) {
        return dayNames[i];
    }

    public class Region {
        private DateUtils mDate;
        private DateUtils mDateTime;
        private String mDateFormat;

        public Region(String dateFormat) {
            this.mDateFormat = dateFormat;
        }

        public DateUtils date() {
            if (this.mDate == null) {
                this.mDate = new DateUtils(this.mDateFormat, false);
            }
            return this.mDate;
        }

        public DateUtils dateTime() {
            if (this.mDateTime == null) {
                this.mDateTime = new DateUtils(this.mDateFormat, true);
            }
            return this.mDateTime;
        }
    }
}

