/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.io;

import com.bradmcevoy.io.ReadingException;
import com.bradmcevoy.io.WritingException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamToStream {
    private static final Logger log = LoggerFactory.getLogger(StreamToStream.class);

    private StreamToStream() {
    }

    public static long readTo(File inFile, OutputStream out, boolean closeOut) throws ReadingException, WritingException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(inFile);
            long l = StreamToStream.readTo(in, out);
            return l;
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {
                log.error("exception closing output stream", (Throwable)ex);
            }
            if (closeOut) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    log.error("exception closing outputstream", (Throwable)ex);
                }
            }
        }
    }

    public static long readTo(InputStream in, File outFile, boolean closeIn) throws ReadingException, WritingException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(outFile);
            long l = StreamToStream.readTo(in, out);
            return l;
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException ex) {
                log.error("exception closing output stream", (Throwable)ex);
            }
            if (closeIn) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    log.error("exception closing inputstream", (Throwable)ex);
                }
            }
        }
    }

    public static long readTo(InputStream in, OutputStream out) throws ReadingException, WritingException {
        return StreamToStream.readTo(in, out, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long readTo(InputStream in, OutputStream out, boolean closeIn, boolean closeOut) throws ReadingException, WritingException {
        long tmReading = 0L;
        long tmWriting = 0L;
        byte[] buf = new byte[1024];
        try {
            int s;
            try {
                long t = System.currentTimeMillis();
                s = in.read(buf);
                t = System.currentTimeMillis() - t;
                tmReading += t;
            }
            catch (IOException ex) {
                throw new ReadingException(ex);
            }
            catch (NullPointerException e) {
                throw new RuntimeException("npe reading inputstream: " + in.getClass(), e);
            }
            long numBytes = 0L;
            int cnt = 0;
            while (s > 0) {
                long t;
                try {
                    numBytes += (long)s;
                    cnt += s;
                    t = System.currentTimeMillis();
                    out.write(buf, 0, s);
                    t = System.currentTimeMillis() - t;
                    tmWriting += t;
                }
                catch (IOException ex) {
                    throw new WritingException(ex);
                }
                try {
                    t = System.currentTimeMillis();
                    s = in.read(buf);
                    t = System.currentTimeMillis() - t;
                    tmReading += t;
                }
                catch (IOException ex) {
                    throw new ReadingException(ex);
                }
            }
            try {
                out.flush();
            }
            catch (IOException ex) {
                throw new WritingException(ex);
            }
            long l = numBytes;
            return l;
        }
        finally {
            if (closeIn) {
                StreamToStream.close(in);
            }
            if (closeOut) {
                StreamToStream.close(out);
            }
        }
    }

    public static void close(OutputStream out) {
        if (out == null) {
            return;
        }
        try {
            out.close();
        }
        catch (IOException ex) {
            log.warn("exception closing output stream", (Throwable)ex);
        }
    }

    public static void close(InputStream in) {
        try {
            in.close();
        }
        catch (IOException ex) {
            log.warn("exception closing inputstream", (Throwable)ex);
        }
        catch (NullPointerException e) {
            log.debug("NPE closing connection. Its ok, it happens sometimes at sun.nio.ch.ChannelInputStream.close(ChannelInputStream.java:96)");
        }
    }
}

