/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.io;

import com.bradmcevoy.io.ChunkStore;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkingInputStream
extends InputStream {
    private static final Logger log = LoggerFactory.getLogger(ChunkingInputStream.class);
    final ChunkStore store;
    private int chunkNum;
    private int pos = -1;
    private byte[] currentChunk;

    public ChunkingInputStream(ChunkStore store) {
        this.store = store;
        this.currentChunk = store.getChunk(this.chunkNum++);
    }

    @Override
    public int read() throws IOException {
        if (this.currentChunk == null) {
            return -1;
        }
        ++this.pos;
        if (this.pos >= this.currentChunk.length) {
            this.currentChunk = this.store.getChunk(this.chunkNum++);
            if (this.currentChunk == null) {
                return -1;
            }
            this.pos = 0;
        }
        int i = this.currentChunk[this.pos] & 0xFF;
        return i;
    }

    public void writeTo(OutputStream out) throws IOException {
        boolean done;
        long t = System.currentTimeMillis();
        boolean bl = done = this.currentChunk == null || this.currentChunk.length == 0;
        while (!done) {
            out.write(this.currentChunk);
            log.debug("chunk: " + this.chunkNum + " - " + this.currentChunk.length);
            this.currentChunk = this.store.getChunk(this.chunkNum++);
            done = this.currentChunk == null || this.currentChunk.length == 0;
        }
        t = System.currentTimeMillis() - t;
        log.debug("transmission time: " + t + "ms");
    }
}

