/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptExecutor {
    private static final Logger log = LoggerFactory.getLogger(ScriptExecutor.class);
    final String process;
    final String[] args;
    final int successCode;
    boolean win32Batch;

    public ScriptExecutor(String process, String[] args, int successCode) {
        this.process = process;
        this.args = args;
        this.successCode = successCode;
        if (process.endsWith(".bat")) {
            this.setWin32Batch(true);
        }
    }

    public boolean isWin32Batch() {
        return this.win32Batch;
    }

    public void setWin32Batch(boolean win32Batch) {
        this.win32Batch = win32Batch;
    }

    public void exec() throws RuntimeException {
        int i;
        log.info("exec: " + this.process);
        int cmdSize = this.args.length + 1;
        if (this.isWin32Batch()) {
            cmdSize += 2;
        }
        String[] cmd = new String[cmdSize];
        int param = 0;
        if (this.isWin32Batch()) {
            cmd[param++] = "cmd.exe";
            cmd[param++] = "/c";
        }
        cmd[param++] = this.process;
        for (i = 0; i < this.args.length; ++i) {
            String s = this.args[i];
            if (s == null) {
                s = "";
            }
            cmd[param++] = s;
        }
        for (i = 0; i < cmd.length; ++i) {
            log.info("cmd: " + i + " = " + cmd[i]);
        }
        Runtime rt = Runtime.getRuntime();
        try {
            Process proc = rt.exec(cmd);
            StreamDiscarder errorDiscarder = new StreamDiscarder(proc.getErrorStream());
            ScriptOutputReader output = new ScriptOutputReader(proc.getInputStream());
            ScriptExecutor.debug("starting process...");
            errorDiscarder.start();
            output.start();
            ScriptExecutor.debug("...waiting for proc...");
            int exitVal = proc.waitFor();
            ScriptExecutor.debug("...got exit val: " + exitVal);
            if (exitVal != this.successCode) {
                throw new RuntimeException(exitVal + " - " + output.toString());
            }
            ScriptExecutor.debug("...waiting for threads to join...");
            output.join(10000L);
            errorDiscarder.join(1000L);
            if (output.isAlive()) {
                output.interrupt();
            }
            ScriptExecutor.debug("...");
            if (errorDiscarder.isAlive()) {
                errorDiscarder.interrupt();
            }
            ScriptExecutor.debug("...done ok");
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        finally {
            log.debug("finished exec");
        }
    }

    private static void debug(Object o) {
        log.debug(o.toString());
    }

    public String toString() {
        String s = "command: " + this.process + " arbuments:";
        for (String arg : this.args) {
            s = s + arg + ",";
        }
        return s;
    }

    private static class ScriptOutputReader
    extends StreamReader {
        private StringBuffer sb = new StringBuffer();
        private boolean found = false;

        public ScriptOutputReader(InputStream is) {
            super(is);
        }

        @Override
        protected void processLine(String cmdOut) {
            this.sb.append(cmdOut);
            log.trace(cmdOut);
        }

        @Override
        public String toString() {
            return this.sb.toString();
        }
    }

    private static class StreamDiscarder
    extends StreamReader {
        public StreamDiscarder(InputStream is) {
            super(is);
        }

        @Override
        protected void processLine(String line) {
            log.trace(line);
        }
    }

    private static abstract class StreamReader
    extends Thread {
        private InputStream is;

        protected abstract void processLine(String var1);

        public StreamReader(InputStream is) {
            this.is = is;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null && !StreamReader.interrupted()) {
                    this.processLine(line);
                }
                br.close();
            }
            catch (IOException ioe) {
                log.error("Exception in StreamReader", (Throwable)ioe);
            }
        }
    }
}

