/*
 * Decompiled with CFR 0.152.
 */
package io.milton.zsync;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Util {
    private static final Logger log = LoggerFactory.getLogger(Util.class);
    public static final String BASE_64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private Util() {
    }

    public static String base64(byte[] buf) {
        int index = 0;
        int bytes = (buf.length * 8 + 5) / 6;
        StringBuilder out = new StringBuilder(bytes);
        for (int i = 0; i < bytes; ++i) {
            int byteOffset = i * 6 / 8;
            int bitOffset = i * 6 % 8;
            if (bitOffset < 3) {
                index = buf[byteOffset] >>> 2 - bitOffset & 0x3F;
            } else {
                index = buf[byteOffset] << bitOffset - 2 & 0x3F;
                if (byteOffset + 1 < buf.length) {
                    index |= (buf[byteOffset + 1] & 0xFF) >>> 8 - (bitOffset - 2);
                }
            }
            out.append(BASE_64.charAt(index));
        }
        return out.toString();
    }

    public static void writeASCII(OutputStream out, String ascii) throws IOException {
        try {
            out.write(ascii.getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public static String readLine(InputStream in) throws IOException {
        StringBuilder s = new StringBuilder();
        int c = in.read();
        while (c != -1 && c != 10) {
            if (c != 13) {
                s.append((char)(c & 0xFF));
            }
            c = in.read();
        }
        if (s.length() == 0 && c == -1) {
            return null;
        }
        return s.toString();
    }

    public static String toHexString(byte[] b) {
        return Util.toHexString(b, 0, b.length);
    }

    public static String toHexString(byte[] b, int off, int len) {
        char[] buf = new char[len * 2];
        int i = 0;
        int j = 0;
        while (i < len) {
            byte k = b[off + i++];
            buf[j++] = HEX_DIGITS[k >>> 4 & 0xF];
            buf[j++] = HEX_DIGITS[k & 0xF];
        }
        return new String(buf);
    }

    public static void close(RandomAccessFile randAccess) {
        if (randAccess != null) {
            try {
                randAccess.close();
            }
            catch (IOException ex) {
                log.warn("Exception closing random access file", (Throwable)ex);
            }
        }
    }

    public static void close(FileChannel rc) {
        if (rc != null) {
            try {
                rc.close();
            }
            catch (IOException ex) {
                log.warn("EXception closing channel", (Throwable)ex);
            }
        }
    }
}

