/*
 * Decompiled with CFR 0.152.
 */
package io.milton.zsync;

import io.milton.http.Range;
import io.milton.zsync.ByteRangeWriter;
import io.milton.zsync.MakeContextEx;
import io.milton.zsync.MapMatcher;
import io.milton.zsync.MetaFileReader;
import io.milton.zsync.OffsetPair;
import io.milton.zsync.RelocWriter;
import io.milton.zsync.RelocateRange;
import io.milton.zsync.SHA1;
import io.milton.zsync.Upload;
import io.milton.zsync.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.io.IOUtils;

public class UploadMakerEx {
    public final File localCopy;
    public final File serversMetafile;
    private MetaFileReader metaFileReader;
    private MakeContextEx uploadContext;
    private Upload upload;

    public UploadMakerEx(File sourceFile, File zsFile) throws IOException {
        this.localCopy = sourceFile;
        this.serversMetafile = zsFile;
        this.upload = new Upload();
        this.initMetaData();
    }

    private void initMetaData() {
        this.metaFileReader = new MetaFileReader(this.serversMetafile);
        this.uploadContext = new MakeContextEx(this.metaFileReader.getHashtable(), this.metaFileReader.getBlockCount(), this.metaFileReader.getBlocksize());
    }

    private void initUpload() throws IOException {
        this.upload.setVersion("testVersion");
        this.upload.setBlocksize(this.metaFileReader.getBlocksize());
        this.upload.setFilelength(this.localCopy.length());
        this.upload.setSha1(new SHA1(this.localCopy).SHA1sum());
        InputStream dataRanges = UploadMakerEx.serversMissingRangesEx(this.uploadContext.getReverseMap(), this.localCopy, this.metaFileReader.getBlocksize());
        InputStream relocRanges = UploadMakerEx.serversRelocationRangesEx(this.uploadContext.getReverseMap(), this.metaFileReader.getBlocksize(), this.localCopy.length(), true);
        this.upload.setRelocStream(relocRanges);
        this.upload.setDataStream(dataRanges);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream serversMissingRangesEx(List<OffsetPair> reverseMap, File local, int blockSize) throws UnsupportedEncodingException, IOException {
        InputStream inputStream;
        ByteRangeWriter dataWriter = new ByteRangeWriter(16384);
        RandomAccessFile randAccess = null;
        Collections.sort(reverseMap, new OffsetPair.LocalSort());
        reverseMap.add(new OffsetPair(local.length(), -1L));
        try {
            randAccess = new RandomAccessFile(local, "r");
            long prevEnd = 0L;
            for (OffsetPair pair : reverseMap) {
                long offset = pair.localOffset;
                if (offset - prevEnd > 0L) {
                    dataWriter.add(new Range(Long.valueOf(prevEnd), Long.valueOf(offset)), randAccess);
                }
                prevEnd = offset + (long)blockSize;
            }
            inputStream = dataWriter.getInputStream();
        }
        catch (Throwable throwable) {
            Util.close(randAccess);
            throw throwable;
        }
        Util.close(randAccess);
        return inputStream;
    }

    public static InputStream serversRelocationRangesEx(List<OffsetPair> reverseMap, int blockSize, long fileLength, boolean combineRanges) throws UnsupportedEncodingException, IOException {
        RelocWriter relocRanges = new RelocWriter(16384);
        Collections.sort(reverseMap, new OffsetPair.RemoteSort());
        ListIterator<OffsetPair> iter = reverseMap.listIterator();
        while (iter.hasNext()) {
            OffsetPair pair = iter.next();
            long localOffset = pair.localOffset;
            long blockIndex = pair.remoteBlock;
            if (localOffset < 0L || localOffset == blockIndex * (long)blockSize || localOffset > fileLength - (long)blockSize) continue;
            Range blockRange = combineRanges ? UploadMakerEx.consecMatchesEx(iter, localOffset, blockIndex, blockSize) : new Range(Long.valueOf(blockIndex), Long.valueOf(blockIndex + 1L));
            RelocateRange relocRange = new RelocateRange(blockRange, localOffset);
            relocRanges.add(relocRange);
        }
        return relocRanges.getInputStream();
    }

    private static Range consecMatchesEx(ListIterator<OffsetPair> iter, long localOffset, long blockIndex, int blockSize) {
        long currBlock = blockIndex;
        long currByte = localOffset;
        while (iter.hasNext()) {
            OffsetPair pair = iter.next();
            if (pair.localOffset == (currByte += (long)blockSize) && pair.remoteBlock == ++currBlock) continue;
            iter.previous();
            return new Range(Long.valueOf(blockIndex), Long.valueOf(currBlock));
        }
        return new Range(Long.valueOf(blockIndex), Long.valueOf(currBlock + 1L));
    }

    public static InputStream getDataRanges(List<Range> ranges, File local) throws IOException {
        int MAX_BUFFER = 0x100000;
        ByteRangeWriter byteRanges = new ByteRangeWriter(MAX_BUFFER);
        RandomAccessFile randAccess = new RandomAccessFile(local, "r");
        for (Range range : ranges) {
            byteRanges.add(range, randAccess);
        }
        return byteRanges.getInputStream();
    }

    public InputStream makeUpload() throws IOException {
        try {
            System.out.print("Matching client and server blocks...");
            long t0 = System.currentTimeMillis();
            MapMatcher matcher = new MapMatcher();
            matcher.mapMatcher(this.localCopy, this.metaFileReader, this.uploadContext);
            long t1 = System.currentTimeMillis();
            long t2 = System.currentTimeMillis();
            this.initUpload();
            long t3 = System.currentTimeMillis();
            return this.upload.getInputStream();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public File getUploadFile() throws IOException {
        InputStream uploadIn = this.makeUpload();
        File uploadFile = File.createTempFile("zsync-upload", this.localCopy.getName());
        FileOutputStream uploadOut = new FileOutputStream(uploadFile);
        IOUtils.copy((InputStream)uploadIn, (OutputStream)uploadOut);
        uploadIn.close();
        uploadOut.close();
        return uploadFile;
    }
}

