/*
 * Decompiled with CFR 0.152.
 */
package io.milton.zsync;

import io.milton.http.Range;
import io.milton.zsync.ByteRangeWriter;
import io.milton.zsync.DataRange;
import io.milton.zsync.MakeContext;
import io.milton.zsync.MapMatcher;
import io.milton.zsync.MetaFileReader;
import io.milton.zsync.RelocWriter;
import io.milton.zsync.RelocateRange;
import io.milton.zsync.SHA1;
import io.milton.zsync.Upload;
import io.milton.zsync.Util;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class UploadMaker {
    public final File localCopy;
    public final File serversMetafile;
    private MetaFileReader metaFileReader;
    private MakeContext makeContext;
    private Upload upload;

    public UploadMaker(File sourceFile, File destMeta) throws IOException {
        this.localCopy = sourceFile;
        this.serversMetafile = destMeta;
        this.upload = new Upload();
    }

    public InputStream makeUpload() throws IOException {
        this.initMetaData();
        try {
            System.out.print("Matching client and server blocks...");
            long t0 = System.currentTimeMillis();
            MapMatcher matcher = new MapMatcher();
            matcher.mapMatcher(this.localCopy, this.metaFileReader, this.makeContext);
            long t1 = System.currentTimeMillis();
            long t2 = System.currentTimeMillis();
            this.initUpload();
            long t3 = System.currentTimeMillis();
            return this.upload.getInputStream();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void init() throws IOException {
        this.initMetaData();
        this.initUpload();
    }

    private void initMetaData() {
        this.metaFileReader = new MetaFileReader(this.serversMetafile);
        this.makeContext = new MakeContext(this.metaFileReader.getHashtable(), new long[this.metaFileReader.getBlockCount()]);
        Arrays.fill(this.makeContext.fileMap, -1L);
    }

    private void initUpload() throws IOException {
        InputStream ranges = UploadMaker.serversMissingRanges(this.makeContext.fileMap, this.localCopy, this.metaFileReader.getBlocksize());
        InputStream relocRanges = UploadMaker.serversRelocationRanges(this.makeContext.fileMap, this.metaFileReader.getBlocksize(), this.localCopy.length(), true);
        this.upload.setVersion("testVersion");
        this.upload.setBlocksize(this.metaFileReader.getBlocksize());
        this.upload.setFilelength(this.localCopy.length());
        this.upload.setSha1(new SHA1(this.localCopy).SHA1sum());
        this.upload.setRelocStream(relocRanges);
        this.upload.setDataStream(ranges);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream serversMissingRanges(long[] fileMap, File local, int blockSize) throws IOException {
        LinkedList<Long> localOffsets = new LinkedList<Long>();
        ByteRangeWriter rangeList = new ByteRangeWriter(16384);
        RandomAccessFile randAccess = null;
        long fileLength = local.length();
        try {
            randAccess = new RandomAccessFile(local, "r");
            for (long offset : fileMap) {
                if (offset <= -1L || offset >= fileLength - (long)blockSize) continue;
                localOffsets.add(offset);
            }
            localOffsets.add(fileLength);
            Collections.sort(localOffsets);
            Long prev = null;
            ListIterator iter = localOffsets.listIterator();
            while (iter.hasNext()) {
                Long curr = (Long)iter.next();
                if (prev != null && curr.equals(prev)) {
                    iter.remove();
                    continue;
                }
                prev = curr;
            }
            long prevEnd = 0L;
            for (Long offset : localOffsets) {
                if (offset - prevEnd > 0L) {
                    rangeList.add(new Range(Long.valueOf(prevEnd), offset), randAccess);
                }
                prevEnd = offset + (long)blockSize;
            }
        }
        catch (Throwable throwable) {
            Util.close(randAccess);
            throw throwable;
        }
        Util.close(randAccess);
        return rangeList.getInputStream();
    }

    public static InputStream serversRelocationRanges(long[] fileMap, int blockSize, long fileLength, boolean combineRanges) throws IOException {
        RelocWriter relocList = new RelocWriter(16384);
        for (int blockIndex = 0; blockIndex < fileMap.length; ++blockIndex) {
            Range blockRange;
            long localOffset = fileMap[blockIndex];
            if (localOffset < 0L || localOffset == (long)(blockIndex * blockSize) || localOffset > fileLength - (long)blockSize) continue;
            if (combineRanges) {
                blockRange = UploadMaker.consecMatches(fileMap, blockSize, blockIndex);
                blockIndex = (int)((long)blockIndex + (blockRange.getFinish() - blockRange.getStart() - 1L));
            } else {
                blockRange = new Range(Long.valueOf(blockIndex), Long.valueOf((long)blockIndex + 1L));
            }
            RelocateRange relocRange = new RelocateRange(blockRange, localOffset);
            relocList.add(relocRange);
        }
        return relocList.getInputStream();
    }

    private static Range consecMatches(long[] fileMap, int blockSize, int blockIndex) {
        int startBlock = blockIndex++;
        long currByte = fileMap[startBlock];
        while (blockIndex < fileMap.length && fileMap[blockIndex] == currByte + (long)blockSize) {
            currByte += (long)blockSize;
            ++blockIndex;
        }
        return new Range(startBlock, blockIndex);
    }

    public static List<DataRange> getDataRanges(List<Range> ranges, File local) throws IOException {
        ArrayList<DataRange> dataRanges = new ArrayList<DataRange>();
        RandomAccessFile randAccess = new RandomAccessFile(local, "r");
        for (Range range : ranges) {
            dataRanges.add(new DataRange(range, randAccess));
        }
        return dataRanges;
    }

    public InputStream getInputStream() throws UnsupportedEncodingException, IOException {
        return this.upload.getInputStream();
    }

    public static InputStream getRelocStream(List<RelocateRange> relocList) throws IOException {
        RelocWriter relocWriter = new RelocWriter(16384);
        for (RelocateRange reloc : relocList) {
            relocWriter.add(reloc);
        }
        return relocWriter.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getDataStream(List<Range> ranges, File local) throws IOException {
        InputStream inputStream;
        ByteRangeWriter dataWriter = new ByteRangeWriter(16384);
        RandomAccessFile randAccess = null;
        try {
            randAccess = new RandomAccessFile(local, "r");
            for (Range range : ranges) {
                dataWriter.add(range, randAccess);
            }
            inputStream = dataWriter.getInputStream();
        }
        catch (Throwable throwable) {
            Util.close(randAccess);
            throw throwable;
        }
        Util.close(randAccess);
        return inputStream;
    }
}

