/*
 * Decompiled with CFR 0.152.
 */
package io.milton.zsync;

import io.milton.zsync.SHA1;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class HeaderMaker {
    public Headers getFullHeader(File file, String url, int blocksize, int[] hashLengths) {
        Headers h = new Headers();
        String sha1 = new SHA1(file.toString()).SHA1sum();
        if (url == null) {
            url = file.getName();
        }
        if (!this.isPowerOfTwo(blocksize)) {
            throw new IllegalArgumentException("Blocksize must be a power of 2 (512, 1024, 2048, ...)");
        }
        this.init(h, file.lastModified(), file.length(), url, blocksize, hashLengths, sha1);
        return h;
    }

    public Headers getFullHeader(Date lastMod, long fileLength, String url, int blocksize, int[] hashLengths, String sha1) {
        Headers h = new Headers();
        this.init(h, lastMod.getTime(), fileLength, url, blocksize, hashLengths, sha1);
        return h;
    }

    private void init(Headers h, long lastMod, long fileLength, String url, int blocksize, int[] hashLengths, String sha1) {
        h.version = "jazsync";
        h.mTime = lastMod;
        h.url = url;
        h.length = fileLength;
        if (!this.isPowerOfTwo(blocksize)) {
            throw new IllegalArgumentException("Blocksize must be a power of 2 (512, 1024, 2048, ...)");
        }
        h.blocksize = blocksize;
        h.setSeqNum(hashLengths[0]);
        h.setRsumBytes(hashLengths[1]);
        h.setChecksumBytes(hashLengths[2]);
        h.sha1 = sha1;
    }

    public String toString(Headers h) {
        String Version = "zsync: jazsyncM";
        String MTime = "MTime: ";
        String Blocksize = "Blocksize: ";
        String Length = "Length: ";
        String HashLengths = "Hash-Lengths: ";
        String URL2 = "URL: ";
        String SHA12 = "SHA-1: ";
        Blocksize = Blocksize + h.blocksize;
        MTime = MTime + this.setMTime("EEE, dd MMM yyyy HH:mm:ss Z", h.mTime);
        Length = Length + h.length;
        URL2 = URL2 + h.url;
        HashLengths = HashLengths + h.hashLengths[0] + "," + h.hashLengths[1] + "," + h.hashLengths[2];
        SHA12 = SHA12 + h.sha1;
        StringBuilder sb = new StringBuilder("");
        sb.append(Version).append("\n");
        sb.append(MTime).append("\n");
        sb.append(Blocksize).append("\n");
        sb.append(Length).append("\n");
        sb.append(HashLengths).append("\n");
        sb.append(URL2).append("\n");
        sb.append(SHA12).append("\n\n");
        String header = sb.toString();
        return header;
    }

    private boolean isPowerOfTwo(int number) {
        boolean isPowerOfTwo = true;
        while (number > 1) {
            if (number % 2 != 0) {
                isPowerOfTwo = false;
                break;
            }
            number /= 2;
        }
        return isPowerOfTwo;
    }

    private String setMTime(String dateFormat, long mtime) {
        Date date = new Date();
        date.setTime(mtime);
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat, Locale.US);
        return sdf.format(date);
    }

    public static class Headers {
        public String version;
        public long mTime;
        public int blocksize;
        public long length;
        public final int[] hashLengths = new int[3];
        public String url;
        public String sha1;

        public int getSeqNum() {
            return this.hashLengths[0];
        }

        public int getRsumButes() {
            return this.hashLengths[1];
        }

        public int getChecksumBytes() {
            return this.hashLengths[2];
        }

        public void setSeqNum(int i) {
            this.hashLengths[0] = i;
        }

        public void setRsumBytes(int i) {
            this.hashLengths[1] = i;
        }

        public void setChecksumBytes(int i) {
            this.hashLengths[2] = i;
        }
    }
}

