/*
 * Decompiled with CFR 0.152.
 */
package io.milton.zsync;

import io.milton.http.Range;
import io.milton.httpclient.zsyncclient.RangeLoader;
import io.milton.zsync.MakeContext;
import io.milton.zsync.MetaFileReader;
import io.milton.zsync.SHA1;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUpdater {
    private static final Logger log = LoggerFactory.getLogger(FileUpdater.class);
    private int maxRanges = 100;

    public void update(File inputFile, MetaFileReader mfr, RangeLoader rangeLoader, MakeContext mc, File newFile) throws Exception {
        log.trace("fileMaker: input: " + inputFile.getAbsolutePath());
        try {
            double a = 10.0;
            int range = 0;
            int blockLength = 0;
            List<Object> rangeList = new ArrayList();
            byte[] data = null;
            FileChannel wChannel = null;
            newFile.createNewFile();
            log.trace("Writing new file: " + newFile.getAbsolutePath());
            wChannel = new FileOutputStream(newFile, true).getChannel();
            ByteBuffer buffer = ByteBuffer.allocate(mfr.getBlocksize());
            log.trace("Reading from file: " + inputFile.getAbsolutePath());
            FileChannel rChannel = new FileInputStream(inputFile).getChannel();
            log.trace("number of map entries: " + mc.fileMap.length);
            for (int i = 0; i < mc.fileMap.length; ++i) {
                mc.fileOffset = mc.fileMap[i];
                if (mc.fileOffset != -1L) {
                    log.trace("  read block from local file: " + mc.fileOffset);
                    rChannel.read(buffer, mc.fileOffset);
                    buffer.flip();
                    wChannel.write(buffer);
                    buffer.clear();
                    continue;
                }
                log.trace("   read block from remote file");
                if (!mc.rangeQueue) {
                    rangeList = this.rangeLookUp(i, mfr.getBlocksize(), mc);
                    range = rangeList.size();
                    data = rangeLoader.get(rangeList);
                } else {
                    log.trace("     already have queued ranges: " + rangeList.size());
                }
                blockLength = this.calcBlockLength(i, mfr.getBlocksize(), (int)mfr.getLength());
                int offset = (range - rangeList.size()) * mfr.getBlocksize();
                buffer.put(data, offset, blockLength);
                buffer.flip();
                wChannel.write(buffer);
                buffer.clear();
                rangeList.remove(0);
                if (!rangeList.isEmpty()) continue;
                mc.rangeQueue = false;
            }
            log.info("Completed file: " + newFile.getAbsolutePath());
            log.info("Checking checksums...");
            SHA1 sha = new SHA1(newFile);
            String actual = sha.SHA1sum();
            String expected = mfr.getSha1();
            if (!actual.equals(expected)) {
                log.error("Checksums don't match - expected: " + expected + "  actual: " + actual);
                throw new RuntimeException("Checksums don't match - expected: " + expected + "  actual: " + actual);
            }
            log.info("checksum matches OK");
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't read or write, check your permissions.");
        }
    }

    private List<Range> rangeLookUp(int i, int blocksize, MakeContext mc) {
        ArrayList<Range> ranges = new ArrayList<Range>();
        while (i < mc.fileMap.length) {
            if (mc.fileMap[i] == -1L) {
                ranges.add(new Range(Long.valueOf((long)i * (long)blocksize), Long.valueOf((long)(i * blocksize) + (long)blocksize)));
            }
            if (ranges.size() >= this.maxRanges) break;
            ++i;
        }
        if (!ranges.isEmpty()) {
            mc.rangeQueue = true;
        }
        return ranges;
    }

    private int calcBlockLength(int i, int blockSize, int length) {
        if ((i + 1) * blockSize < length) {
            return blockSize;
        }
        return this.calcBlockLength_b(i, blockSize, length);
    }

    private int calcBlockLength_b(int i, int blockSize, int length) {
        return blockSize + (length - (i * blockSize + blockSize));
    }
}

