/*
 * Decompiled with CFR 0.152.
 */
package io.milton.zsync;

import io.milton.zsync.RollingChecksum;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Configuration
implements Cloneable,
Serializable {
    public static final int BLOCK_LENGTH = 1024;
    public static final int CHUNK_SIZE = 32768;
    public transient MessageDigest strongSum;
    public transient RollingChecksum weakSum;
    public int blockLength;
    public int strongSumLength;
    public boolean doRunLength;
    public byte[] checksumSeed;
    public int chunkSize;

    public Configuration() {
        this.blockLength = 1024;
        this.chunkSize = 32768;
    }

    private Configuration(Configuration that) {
        try {
            this.strongSum = (MessageDigest)(that.strongSum != null ? that.strongSum.clone() : null);
        }
        catch (CloneNotSupportedException cnse) {
            try {
                this.strongSum = MessageDigest.getInstance(that.strongSum.getAlgorithm());
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new Error(nsae);
            }
        }
        this.weakSum = (RollingChecksum)(that.weakSum != null ? that.weakSum.clone() : null);
        this.blockLength = that.blockLength;
        this.doRunLength = that.doRunLength;
        this.strongSumLength = that.strongSumLength;
        this.checksumSeed = that.checksumSeed != null ? (byte[])that.checksumSeed.clone() : null;
        this.chunkSize = that.chunkSize;
    }

    public int getBlock() {
        return this.blockLength;
    }

    public Object clone() {
        return new Configuration(this);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeUTF(this.strongSum != null ? this.strongSum.getAlgorithm() : "NONE");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        String s = in.readUTF();
        if (!s.equals("NONE")) {
            try {
                this.strongSum = MessageDigest.getInstance(s);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new InvalidObjectException(nsae.getMessage());
            }
        }
    }
}

