/*
 * Decompiled with CFR 0.152.
 */
package io.milton.zsync;

import io.milton.zsync.Util;
import java.io.Serializable;
import java.util.Arrays;

public class ChecksumPair
implements Cloneable,
Serializable {
    int weak;
    byte[] strong;
    long offset;
    int length;
    int seq;

    public ChecksumPair(int weak, byte[] strong, long offset, int length, int seq) {
        this.weak = weak;
        this.strong = strong;
        this.offset = offset;
        this.length = length;
        this.seq = seq;
    }

    public ChecksumPair(int weak, byte[] strong, long offset) {
        this(weak, strong, offset, 0, 0);
    }

    public ChecksumPair(int weak, byte[] strong) {
        this(weak, strong, -1L, 0, 0);
    }

    public ChecksumPair(int weak) {
        this(weak, null, -1L, 0, 0);
    }

    public ChecksumPair(int weak, byte[] strong, int seq) {
        this(weak, null, -1L, 0, seq);
    }

    ChecksumPair() {
    }

    public int getWeak() {
        return this.weak;
    }

    public String getWeakHex() {
        return Integer.toHexString(this.weak);
    }

    public String getStrongHex() {
        return Util.toHexString(this.strong);
    }

    public byte[] getStrong() {
        return this.strong;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public int getSequence() {
        return this.seq;
    }

    public int hashCode() {
        byte[] weakByte = new byte[]{(byte)(this.weak >> 24), (byte)(this.weak << 8 >> 24), (byte)(this.weak << 16 >> 24), (byte)(this.weak << 24 >> 24)};
        byte[] weakAdd = new byte[]{(byte)(weakByte[0] + weakByte[1]), (byte)(weakByte[2] + weakByte[3])};
        int hashCode = 0;
        for (int i = 0; i < 2; ++i) {
            int shift = (1 - i) * 8;
            hashCode += (weakAdd[i] & 0xFF) << shift;
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.weak == ((ChecksumPair)obj).weak && Arrays.equals(this.strong, ((ChecksumPair)obj).strong);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        String s = Integer.toHexString(this.getWeak());
        for (int i = 0; i < 8 - s.length(); ++i) {
            buf.append('0');
        }
        String weakS = buf.toString() + s;
        return "len=" + this.length + " offset=" + this.offset + " weak=" + weakS + " strong=" + Util.toHexString(this.strong) + " seq=" + this.seq;
    }
}

