/*
 * Decompiled with CFR 0.152.
 */
package io.milton.zsync;

import io.milton.zsync.ChecksumPair;
import java.util.ArrayList;
import java.util.Arrays;

public class ChainingHash {
    private ArrayList<ArrayList> hashArray;
    private int arraySize;
    private int index;

    public ChainingHash(int size) {
        this.arraySize = size;
        this.hashArray = new ArrayList(this.arraySize);
        for (int i = 0; i < this.arraySize; ++i) {
            this.hashArray.add(i, new ArrayList());
        }
    }

    public int hashFunction(ChecksumPair pKey) {
        return pKey.hashCode() % this.arraySize;
    }

    public void insert(ChecksumPair pKey) {
        int hashValue = this.hashFunction(pKey);
        this.hashArray.get(hashValue).add(pKey);
    }

    public void delete(ChecksumPair pKey) {
        int hashValue = this.hashFunction(pKey);
        this.hashArray.get(hashValue).remove(pKey);
    }

    public ChecksumPair find(ChecksumPair pKey) {
        int hashValue = this.hashFunction(pKey);
        ChecksumPair p = null;
        for (int i = 0; i < this.hashArray.get(hashValue).size(); ++i) {
            p = (ChecksumPair)this.hashArray.get(hashValue).get(i);
            if (p.getWeak() != pKey.getWeak()) continue;
            this.index = i;
            return p;
        }
        return null;
    }

    public ChecksumPair findMatch(ChecksumPair pKey) {
        int hashValue = this.hashFunction(pKey);
        ChecksumPair p = (ChecksumPair)this.hashArray.get(hashValue).get(this.index);
        if (p.getWeak() == pKey.getWeak() && Arrays.equals(p.getStrong(), pKey.getStrong())) {
            return p;
        }
        p = null;
        for (int i = 0; i < this.hashArray.get(hashValue).size(); ++i) {
            p = (ChecksumPair)this.hashArray.get(hashValue).get(i);
            if (p.getWeak() != pKey.getWeak() || !Arrays.equals(p.getStrong(), pKey.getStrong())) continue;
            return p;
        }
        return null;
    }

    public void displayTable() {
        for (int l = 0; l < this.hashArray.size(); ++l) {
            for (int i = 0; i < this.hashArray.get(l).size(); ++i) {
                System.out.println(l + ". list: " + ((ChecksumPair)this.hashArray.get(l).get(i)).toString());
            }
        }
    }
}

