/*
 * Decompiled with CFR 0.152.
 */
package io.milton.zsync;

import io.milton.common.BufferingOutputStream;
import io.milton.http.Range;
import io.milton.zsync.Upload;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;

public class ByteRangeWriter {
    private BufferingOutputStream dataOut;
    private byte[] copyBuffer;
    private boolean first;

    public ByteRangeWriter(int buffersize) {
        this.dataOut = new BufferingOutputStream(buffersize);
        this.copyBuffer = new byte[2048];
        this.first = true;
    }

    public void add(Range range, RandomAccessFile randAccess) throws UnsupportedEncodingException, IOException {
        String rangeKV = Upload.paramString("Range", range.getRange());
        if (!this.first) {
            rangeKV = '\n' + rangeKV;
        }
        this.dataOut.write(rangeKV.getBytes("US-ASCII"));
        this.first = false;
        long bytesLeft = range.getFinish() - range.getStart();
        int bytesRead = 0;
        int bytesToRead = (int)Math.min(bytesLeft, (long)this.copyBuffer.length);
        randAccess.seek(range.getStart());
        while (bytesLeft > 0L) {
            bytesRead = randAccess.read(this.copyBuffer, 0, bytesToRead);
            this.dataOut.write(this.copyBuffer, 0, bytesRead);
            bytesToRead = (int)Math.min(bytesLeft -= (long)bytesRead, (long)this.copyBuffer.length);
        }
    }

    public InputStream getInputStream() throws IOException {
        this.dataOut.close();
        return this.dataOut.getInputStream();
    }
}

