/*
 * Decompiled with CFR 0.152.
 */
package io.milton.httpclient.parse;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class PropertyAccessor {
    private final List<Converter> converters;

    public PropertyAccessor(List<Converter> converters) {
        this.converters = converters;
    }

    public PropertyAccessor() {
        this.converters = new ArrayList<Converter>();
        this.converters.add(new UUIDConverter());
    }

    public void set(Object bean, Method writeMethod, Object value) {
        Class<?>[] paramTypes = writeMethod.getParameterTypes();
        if (paramTypes == null || paramTypes.length == 0) {
            throw new RuntimeException("Can't set no-args setter: " + writeMethod.getName() + " on class " + bean.getClass());
        }
        if (paramTypes.length > 1) {
            throw new RuntimeException("Cant set multi arg setter: " + writeMethod.getName() + " on class: " + bean.getClass());
        }
        try {
            if (value == null) {
                writeMethod.invoke(bean, new Object[]{null});
            } else {
                Class<?> dest = paramTypes[0];
                Class<?> source = value.getClass();
                if (!dest.isAssignableFrom(source)) {
                    value = this.convert(value, dest);
                }
                writeMethod.invoke(bean, value);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Prop: " + writeMethod.getName(), e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Prop: " + writeMethod.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Prop: " + writeMethod.getName(), e);
        }
    }

    public <T> T get(Object bean, Method readMethod, Class<T> c) {
        Object value;
        Class<?>[] paramTypes = readMethod.getParameterTypes();
        if (paramTypes != null && paramTypes.length > 0) {
            throw new RuntimeException("Can't get with multi args getter: " + readMethod.getName() + " on class " + bean.getClass());
        }
        try {
            value = readMethod.invoke(bean, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Getter: " + readMethod.getName(), ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException("Getter: " + readMethod.getName(), ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("Getter: " + readMethod.getName(), ex);
        }
        if (value == null) {
            return null;
        }
        Class<?> rawClass = value.getClass();
        if (!c.isAssignableFrom(rawClass)) {
            value = this.convert(value, c);
        }
        return (T)value;
    }

    private Object convert(Object value, Class dest) {
        for (Converter c : this.converters) {
            if (!c.getTarget().isAssignableFrom(dest)) continue;
            return c.convert(value);
        }
        throw new RuntimeException("No converters are compatible with the dest class: " + dest.getCanonicalName());
    }

    public class UUIDConverter
    implements Converter {
        @Override
        public Class getTarget() {
            return UUID.class;
        }

        @Override
        public Object convert(Object source) {
            if (source instanceof UUID) {
                return source;
            }
            if (source instanceof String) {
                String s = (String)source;
                return UUID.fromString(s);
            }
            throw new RuntimeException("Unsupported source type: " + source.getClass());
        }
    }

    public static interface Converter {
        public Class getTarget();

        public Object convert(Object var1);
    }
}

