/*
 * Decompiled with CFR 0.152.
 */
package io.milton.httpclient.cardsync.parse;

import info.ineighborhood.cardme.engine.VCardEngine;
import info.ineighborhood.cardme.io.VCardWriter;
import info.ineighborhood.cardme.vcard.VCard;
import info.ineighborhood.cardme.vcard.VCardImpl;
import info.ineighborhood.cardme.vcard.features.BeginFeature;
import info.ineighborhood.cardme.vcard.features.EndFeature;
import info.ineighborhood.cardme.vcard.features.FormattedNameFeature;
import info.ineighborhood.cardme.vcard.features.NameFeature;
import info.ineighborhood.cardme.vcard.features.UIDFeature;
import info.ineighborhood.cardme.vcard.types.BeginType;
import info.ineighborhood.cardme.vcard.types.EndType;
import info.ineighborhood.cardme.vcard.types.FormattedNameType;
import info.ineighborhood.cardme.vcard.types.NameType;
import info.ineighborhood.cardme.vcard.types.UIDType;
import io.milton.httpclient.calsync.parse.annotation.Description;
import io.milton.httpclient.calsync.parse.annotation.EndDate;
import io.milton.httpclient.calsync.parse.annotation.Uid;
import io.milton.httpclient.parse.PropertyAccessor;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.beanutils.PropertyUtils;

public class CardDavBeanPropertyMapper {
    private final Map<Class, Mapper> mapOfMappers;
    private final PropertyAccessor propertyAccessor;

    public CardDavBeanPropertyMapper(PropertyAccessor propertyAccessor) {
        this.propertyAccessor = propertyAccessor;
        this.mapOfMappers = new HashMap<Class, Mapper>();
        this.addMapper(Uid.class, new UidMapper());
        this.addMapper(Description.class, new GivenNameMapper());
        this.addMapper(EndDate.class, new LastNameMapper());
    }

    private void addMapper(Class c, Mapper m) {
        this.mapOfMappers.put(c, m);
    }

    public void toBean(Object bean, String icalText) {
        PropertyDescriptor[] pds;
        VCard vcard;
        VCardEngine cardEngine = new VCardEngine();
        try {
            vcard = cardEngine.parse(icalText);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        for (PropertyDescriptor pd : pds = PropertyUtils.getPropertyDescriptors((Object)bean)) {
            Annotation[] annotations;
            if (pd.getReadMethod() == null || pd.getWriteMethod() == null) continue;
            Method read = pd.getReadMethod();
            for (Annotation anno : annotations = read.getAnnotations()) {
                Mapper mapper = this.mapOfMappers.get(anno.annotationType());
                if (mapper == null) continue;
                mapper.mapToBean(vcard, bean, pd);
            }
        }
    }

    public <T> T getProperty(Object bean, Class annotationClass, Class<T> valueClass) {
        PropertyDescriptor[] pds;
        for (PropertyDescriptor pd : pds = PropertyUtils.getPropertyDescriptors((Object)bean)) {
            Annotation[] annotations;
            if (pd.getReadMethod() == null || pd.getWriteMethod() == null) continue;
            Method read = pd.getReadMethod();
            for (Annotation anno : annotations = read.getAnnotations()) {
                if (anno.annotationType() != annotationClass) continue;
                return this.propertyAccessor.get(bean, read, valueClass);
            }
        }
        return null;
    }

    public String toVCard(Object bean) {
        NameFeature nameFeature;
        PropertyDescriptor[] pds;
        VCardImpl card = new VCardImpl();
        card.setBegin((BeginFeature)new BeginType());
        for (PropertyDescriptor pd : pds = PropertyUtils.getPropertyDescriptors((Object)bean)) {
            Annotation[] annotations;
            if (pd.getReadMethod() == null || pd.getWriteMethod() == null) continue;
            Method read = pd.getReadMethod();
            for (Annotation anno : annotations = read.getAnnotations()) {
                Mapper mapper = this.mapOfMappers.get(anno.annotationType());
                if (mapper == null) continue;
                mapper.mapToCard((VCard)card, bean, pd);
            }
        }
        FormattedNameFeature fname = card.getFormattedName();
        if (fname == null && (nameFeature = card.getName()) != null) {
            String formattedName = nameFeature.getGivenName() + " " + nameFeature.getFamilyName();
            fname = new FormattedNameType(formattedName);
            card.setFormattedName(fname);
        }
        card.setEnd((EndFeature)new EndType());
        VCardWriter writer = new VCardWriter();
        writer.setVCard((VCard)card);
        String text = writer.buildVCardString();
        return text;
    }

    public class LastNameMapper
    extends Mapper {
        @Override
        void mapToBean(VCard card, Object bean, PropertyDescriptor pd) {
            if (card.getName() != null) {
                String s = card.getName().getFamilyName();
                CardDavBeanPropertyMapper.this.propertyAccessor.set(bean, pd.getWriteMethod(), s);
            }
        }

        @Override
        void mapToCard(VCard card, Object bean, PropertyDescriptor pd) {
            if (card.getName() == null) {
                NameType nf = new NameType();
                card.setName((NameFeature)nf);
            }
            String s = CardDavBeanPropertyMapper.this.propertyAccessor.get(bean, pd.getReadMethod(), String.class);
            card.getName().setFamilyName(s);
        }
    }

    public class GivenNameMapper
    extends Mapper {
        @Override
        void mapToBean(VCard card, Object bean, PropertyDescriptor pd) {
            if (card.getName() != null) {
                String s = card.getName().getGivenName();
                CardDavBeanPropertyMapper.this.propertyAccessor.set(bean, pd.getWriteMethod(), s);
            }
        }

        @Override
        void mapToCard(VCard card, Object bean, PropertyDescriptor pd) {
            if (card.getName() == null) {
                NameType nf = new NameType();
                card.setName((NameFeature)nf);
            }
            String s = CardDavBeanPropertyMapper.this.propertyAccessor.get(bean, pd.getReadMethod(), String.class);
            card.getName().setGivenName(s);
        }
    }

    public class UidMapper
    extends Mapper {
        @Override
        void mapToBean(VCard card, Object bean, PropertyDescriptor pd) {
            Method m = pd.getWriteMethod();
            String uid = card.getUID() != null && card.getUID().hasUID() ? card.getUID().getUID() : UUID.randomUUID().toString();
            CardDavBeanPropertyMapper.this.propertyAccessor.set(bean, m, uid);
        }

        @Override
        void mapToCard(VCard card, Object bean, PropertyDescriptor pd) {
            String uid = CardDavBeanPropertyMapper.this.propertyAccessor.get(bean, pd.getReadMethod(), String.class);
            card.setUID((UIDFeature)new UIDType(uid));
        }
    }

    public abstract class Mapper {
        abstract void mapToBean(VCard var1, Object var2, PropertyDescriptor var3);

        abstract void mapToCard(VCard var1, Object var2, PropertyDescriptor var3);
    }
}

